/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.auth;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class GSSContextKrb5 {
    private static final String PRINCIPAL_NAME_OID = "1.2.840.113554.1.2.2.1";
    private static final String KRB5_OID = "1.2.840.113554.1.2.2";
    private static final String USE_SUBJECTS_CREDS_ONLY = "javax.security.auth.useSubjectCredsOnly";
    private GSSContext context = null;

    public void create(String host) throws UnknownHostException, GSSException {
        Oid krb5 = new Oid(KRB5_OID);
        Oid principalName = new Oid(PRINCIPAL_NAME_OID);
        System.setProperty(USE_SUBJECTS_CREDS_ONLY, "false");
        GSSManager mgr = GSSManager.getInstance();
        String cname = InetAddress.getByName(host).getCanonicalHostName();
        GSSName gssHost = mgr.createName("host/" + cname, principalName);
        this.context = mgr.createContext(gssHost, krb5, null, 0);
        this.context.requestMutualAuth(true);
        this.context.requestConf(true);
        this.context.requestInteg(true);
        this.context.requestCredDeleg(true);
        this.context.requestAnonymity(false);
    }

    public boolean isEstablished() {
        return this.context.isEstablished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] init(byte[] token, int s, int l) throws GSSException, SecurityException {
        try {
            byte[] byArray = this.context.initSecContext(token, 0, l);
            return byArray;
        }
        finally {
            if (System.getProperty(USE_SUBJECTS_CREDS_ONLY) == null) {
                System.setProperty(USE_SUBJECTS_CREDS_ONLY, "true");
            }
        }
    }

    public byte[] getMIC(byte[] message, int s, int l) throws GSSException {
        MessageProp prop = new MessageProp(0, true);
        return this.context.getMIC(message, s, l, prop);
    }

    public void dispose() throws GSSException {
        this.context.dispose();
    }
}

