/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2;

import com.trilead.ssh2.IOWarningException;
import com.trilead.ssh2.RandomFactory;
import com.trilead.ssh2.crypto.Base64;
import com.trilead.ssh2.crypto.digest.Digest;
import com.trilead.ssh2.crypto.digest.MD5;
import com.trilead.ssh2.crypto.digest.MessageMac;
import com.trilead.ssh2.crypto.digest.SHA1;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.signature.KeyAlgorithm;
import com.trilead.ssh2.signature.KeyAlgorithmManager;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;

public class KnownHosts {
    private static final Logger LOGGER = Logger.getLogger(KnownHosts.class);
    public static final int HOSTKEY_IS_OK = 0;
    public static final int HOSTKEY_IS_NEW = 1;
    public static final int HOSTKEY_HAS_CHANGED = 2;
    private static final SecureRandom SECURE_RANDOM = RandomFactory.create();
    private final LinkedList<KnownHostsEntry> publicKeys = new LinkedList();

    public KnownHosts() {
    }

    public KnownHosts(char[] knownHostsData) throws IOException {
        this.initialize(knownHostsData);
    }

    public KnownHosts(File knownHosts) throws IOException {
        this.initialize(knownHosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHostkey(String[] hostnames, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException {
        if (hostnames == null) {
            throw new IllegalArgumentException("hostnames may not be null");
        }
        for (KeyAlgorithm<PublicKey, PrivateKey> algorithm : KeyAlgorithmManager.getSupportedAlgorithms()) {
            if (!serverHostKeyAlgorithm.equals(algorithm.getKeyFormat())) continue;
            PublicKey publicKey = algorithm.decodePublicKey(serverHostKey);
            LinkedList<KnownHostsEntry> linkedList = this.publicKeys;
            synchronized (linkedList) {
                this.publicKeys.add(new KnownHostsEntry(hostnames, publicKey, serverHostKeyAlgorithm));
            }
            return;
        }
        throw new IOWarningException("Unknwon host key type (" + serverHostKeyAlgorithm + ")");
    }

    public void addHostkeys(char[] knownHostsData) throws IOException {
        this.initialize(knownHostsData);
    }

    public void addHostkeys(File knownHosts) throws IOException {
        this.initialize(knownHosts);
    }

    public static String createHashedHostname(String hostname) {
        SHA1 sha1 = new SHA1();
        byte[] salt = new byte[sha1.getDigestLength()];
        SECURE_RANDOM.nextBytes(salt);
        byte[] hash = KnownHosts.hmacSha1Hash(salt, hostname);
        String base64_salt = new String(Base64.encode(salt));
        String base64_hash = new String(Base64.encode(hash));
        return "|1|" + base64_salt + "|" + base64_hash;
    }

    private static byte[] hmacSha1Hash(byte[] salt, String hostname) {
        if (salt.length != 20) {
            throw new IllegalArgumentException("Salt has wrong length (" + salt.length + ")");
        }
        MessageMac messageMac = new MessageMac("hmac-sha1", salt);
        try {
            byte[] message = hostname.getBytes("ISO-8859-1");
            messageMac.update(message, 0, message.length);
        }
        catch (UnsupportedEncodingException ignore) {
            byte[] message = hostname.getBytes();
            messageMac.update(message, 0, message.length);
        }
        byte[] dig = new byte[20];
        messageMac.getMac(dig, 0);
        return dig;
    }

    private boolean checkHashed(String entry, String hostname) {
        if (!entry.startsWith("|1|")) {
            return false;
        }
        int delim_idx = entry.indexOf(124, 3);
        if (delim_idx == -1) {
            return false;
        }
        String salt_base64 = entry.substring(3, delim_idx);
        String hash_base64 = entry.substring(delim_idx + 1);
        byte[] salt = null;
        byte[] hash = null;
        try {
            salt = Base64.decode(salt_base64.toCharArray());
            hash = Base64.decode(hash_base64.toCharArray());
        }
        catch (IOException e) {
            return false;
        }
        SHA1 sha1 = new SHA1();
        if (salt.length != sha1.getDigestLength()) {
            return false;
        }
        byte[] dig = KnownHosts.hmacSha1Hash(salt, hostname);
        for (int i = 0; i < dig.length; ++i) {
            if (dig[i] == hash[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkKey(String remoteHostname, PublicKey remoteKey) {
        int result = 1;
        LinkedList<KnownHostsEntry> linkedList = this.publicKeys;
        synchronized (linkedList) {
            for (KnownHostsEntry ke : this.publicKeys) {
                if (!this.hostnameMatches(ke.patterns, remoteHostname)) continue;
                boolean res = this.matchKeys(ke.key, remoteKey);
                if (res) {
                    return 0;
                }
                result = 2;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<KnownHostsEntry> getAllKnownHostEntries(String hostname) {
        Vector<KnownHostsEntry> knownHostsEntries = new Vector<KnownHostsEntry>();
        LinkedList<KnownHostsEntry> linkedList = this.publicKeys;
        synchronized (linkedList) {
            for (KnownHostsEntry ke : this.publicKeys) {
                if (!this.hostnameMatches(ke.patterns, hostname)) continue;
                knownHostsEntries.addElement(ke);
            }
        }
        return knownHostsEntries;
    }

    public String[] getPreferredServerHostkeyAlgorithmOrder(String hostname) {
        InetAddress[] ipAddresses;
        String[] algos = this.recommendHostkeyAlgorithms(hostname);
        if (algos != null) {
            return algos;
        }
        try {
            ipAddresses = InetAddress.getAllByName(hostname);
        }
        catch (UnknownHostException e) {
            return null;
        }
        for (InetAddress ipAddress : ipAddresses) {
            algos = this.recommendHostkeyAlgorithms(ipAddress.getHostAddress());
            if (algos == null) continue;
            return algos;
        }
        return null;
    }

    private boolean hostnameMatches(String[] hostpatterns, String hostname) {
        boolean isMatch = false;
        boolean negate = false;
        hostname = hostname.toLowerCase();
        for (String hostpattern : hostpatterns) {
            String bracketizedHost;
            if (hostpattern == null) continue;
            String pattern = null;
            if (hostpattern.length() > 0 && hostpattern.charAt(0) == '!') {
                pattern = hostpattern.substring(1);
                negate = true;
            } else {
                pattern = hostpattern;
                negate = false;
            }
            if (isMatch && !negate) continue;
            if (pattern.charAt(0) == '|') {
                if (!this.checkHashed(pattern, hostname)) continue;
                if (negate) {
                    return false;
                }
                isMatch = true;
                continue;
            }
            if ((pattern = pattern.toLowerCase()).indexOf(63) != -1 || pattern.indexOf(42) != -1) {
                if (!this.pseudoRegex(pattern.toCharArray(), 0, hostname.toCharArray(), 0)) continue;
                if (negate) {
                    return false;
                }
                isMatch = true;
                continue;
            }
            if (pattern.compareTo(hostname) == 0) {
                if (negate) {
                    return false;
                }
                isMatch = true;
                continue;
            }
            int indexColon = pattern.indexOf(58);
            int indexLastColon = pattern.indexOf(58);
            if (indexColon <= 0 || indexColon >= pattern.length() - 2 || indexColon != indexLastColon || !pattern.startsWith(bracketizedHost = "[" + hostname + "]")) continue;
            if (negate) {
                return false;
            }
            isMatch = true;
        }
        return isMatch;
    }

    private void initialize(char[] knownHostsData) throws IOException {
        BufferedReader br = new BufferedReader(new CharArrayReader(knownHostsData));
        String line = br.readLine();
        while (line != null) {
            String[] arr;
            if (!(line = line.trim()).startsWith("#") && (arr = line.split(" ")).length >= 3) {
                String serverHostKeyAlgorithm = arr[1];
                boolean supportedKeyType = false;
                for (KeyAlgorithm<PublicKey, PrivateKey> algorithm : KeyAlgorithmManager.getSupportedAlgorithms()) {
                    if (!algorithm.getKeyFormat().equals(serverHostKeyAlgorithm)) continue;
                    supportedKeyType = true;
                    break;
                }
                if (!supportedKeyType) {
                    LOGGER.log(1, "Unsupported key type: " + serverHostKeyAlgorithm);
                } else {
                    String[] hostnames = arr[0].split(",");
                    byte[] msg = Base64.decode(arr[2].toCharArray());
                    try {
                        this.addHostkey(hostnames, serverHostKeyAlgorithm, msg);
                    }
                    catch (IOWarningException ex) {
                        LOGGER.log(30, "Ignored invalid line '" + line + "'", ex);
                    }
                }
            }
            line = br.readLine();
        }
    }

    private void initialize(File knownHosts) throws IOException {
        char[] buffer = new char[512];
        CharArrayWriter charWriter = new CharArrayWriter();
        if (!knownHosts.createNewFile()) {
            LOGGER.log(10, "Could not create known hosts file");
        }
        try (FileReader reader = new FileReader(knownHosts);){
            int readCharCount;
            while ((readCharCount = reader.read(buffer)) >= 0) {
                charWriter.write(buffer, 0, readCharCount);
            }
        }
        this.initialize(charWriter.toCharArray());
    }

    private boolean matchKeys(PublicKey key1, PublicKey key2) {
        if (null == key1) {
            return null == key2;
        }
        return key1.equals(key2);
    }

    private boolean pseudoRegex(char[] pattern, int i, char[] match, int j) {
        while (pattern.length != i) {
            if (pattern[i] == '*') {
                if (pattern.length == ++i) {
                    return true;
                }
                if (pattern[i] != '*' && pattern[i] != '?') {
                    do {
                        if (pattern[i] != match[j] || !this.pseudoRegex(pattern, i + 1, match, j + 1)) continue;
                        return true;
                    } while (match.length != ++j);
                    return false;
                }
                do {
                    if (!this.pseudoRegex(pattern, i, match, j)) continue;
                    return true;
                } while (match.length != ++j);
                return false;
            }
            if (match.length == j) {
                return false;
            }
            if (pattern[i] != '?' && pattern[i] != match[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return match.length == j;
    }

    private String[] recommendHostkeyAlgorithms(String hostname) {
        String preferredAlgo = null;
        Vector<KnownHostsEntry> keys = this.getAllKnownHostEntries(hostname);
        for (KnownHostsEntry key : keys) {
            String thisAlgo = key.algorithm;
            if (preferredAlgo != null) {
                if (preferredAlgo.equals(thisAlgo)) continue;
                return null;
            }
            preferredAlgo = thisAlgo;
        }
        if (preferredAlgo == null) {
            return null;
        }
        ArrayList<String> supportedAlgorithms = new ArrayList<String>();
        for (KeyAlgorithm<PublicKey, PrivateKey> algorithm : KeyAlgorithmManager.getSupportedAlgorithms()) {
            supportedAlgorithms.add(supportedAlgorithms.size(), algorithm.getKeyFormat());
        }
        if (supportedAlgorithms.contains(preferredAlgo)) {
            supportedAlgorithms.remove(preferredAlgo);
            supportedAlgorithms.add(0, preferredAlgo);
        }
        return supportedAlgorithms.toArray(new String[supportedAlgorithms.size()]);
    }

    public int verifyHostkey(String hostname, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException {
        InetAddress[] ipAdresses;
        PublicKey remoteKey = this.decodeHostKey(serverHostKeyAlgorithm, serverHostKey);
        int result = this.checkKey(hostname, remoteKey);
        if (result == 0) {
            return result;
        }
        try {
            ipAdresses = InetAddress.getAllByName(hostname);
        }
        catch (UnknownHostException e) {
            return result;
        }
        for (InetAddress ipAdress : ipAdresses) {
            int newresult = this.checkKey(ipAdress.getHostAddress(), remoteKey);
            if (newresult == 0) {
                return newresult;
            }
            if (newresult != 2) continue;
            result = 2;
        }
        return result;
    }

    private PublicKey decodeHostKey(String hostKeyAlgorithm, byte[] encodedHostKey) throws IOException {
        for (KeyAlgorithm<PublicKey, PrivateKey> algorithm : KeyAlgorithmManager.getSupportedAlgorithms()) {
            if (!algorithm.getKeyFormat().equals(hostKeyAlgorithm)) continue;
            return algorithm.decodePublicKey(encodedHostKey);
        }
        throw new IllegalArgumentException("Unknown hostkey type " + hostKeyAlgorithm);
    }

    public static void addHostkeyToFile(File knownHosts, String[] hostnames, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException {
        if (hostnames == null || hostnames.length == 0) {
            throw new IllegalArgumentException("Need at least one hostname specification");
        }
        if (serverHostKeyAlgorithm == null || serverHostKey == null) {
            throw new IllegalArgumentException();
        }
        CharArrayWriter writer = new CharArrayWriter();
        for (int i = 0; i < hostnames.length; ++i) {
            if (i != 0) {
                writer.write(44);
            }
            writer.write(hostnames[i]);
        }
        writer.write(32);
        writer.write(serverHostKeyAlgorithm);
        writer.write(32);
        writer.write(Base64.encode(serverHostKey));
        writer.write("\n");
        char[] entry = writer.toCharArray();
        RandomAccessFile raf = new RandomAccessFile(knownHosts, "rw");
        long len = raf.length();
        if (len > 0L) {
            raf.seek(len - 1L);
            int last = raf.read();
            if (last != 10) {
                raf.write(10);
            }
        }
        raf.write(new String(entry).getBytes("ISO-8859-1"));
        raf.close();
    }

    private static byte[] rawFingerPrint(String type, String keyType, byte[] hostkey) {
        Digest dig;
        if ("md5".equals(type)) {
            dig = new MD5();
        } else if ("sha1".equals(type)) {
            dig = new SHA1();
        } else {
            throw new IllegalArgumentException("Unknown hash type " + type);
        }
        boolean supportedKeyType = false;
        for (KeyAlgorithm<PublicKey, PrivateKey> algorithm : KeyAlgorithmManager.getSupportedAlgorithms()) {
            if (!algorithm.getKeyFormat().equals(keyType)) continue;
            supportedKeyType = true;
            break;
        }
        if (!supportedKeyType) {
            throw new IllegalArgumentException("Unknown key type " + keyType);
        }
        if (hostkey == null) {
            throw new IllegalArgumentException("hostkey is null");
        }
        dig.update(hostkey);
        byte[] res = new byte[dig.getDigestLength()];
        dig.digest(res);
        return res;
    }

    private static String rawToHexFingerprint(byte[] fingerprint) {
        char[] alpha = "0123456789abcdef".toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fingerprint.length; ++i) {
            if (i != 0) {
                sb.append(':');
            }
            int b = fingerprint[i] & 0xFF;
            sb.append(alpha[b >> 4]);
            sb.append(alpha[b & 0xF]);
        }
        return sb.toString();
    }

    private static String rawToBubblebabbleFingerprint(byte[] raw) {
        char[] v = "aeiouy".toCharArray();
        char[] c = "bcdfghklmnprstvzx".toCharArray();
        StringBuilder sb = new StringBuilder();
        int seed = 1;
        int rounds = raw.length / 2 + 1;
        sb.append('x');
        for (int i = 0; i < rounds; ++i) {
            if (i + 1 < rounds || raw.length % 2 != 0) {
                sb.append(v[((raw[2 * i] >> 6 & 3) + seed) % 6]);
                sb.append(c[raw[2 * i] >> 2 & 0xF]);
                sb.append(v[((raw[2 * i] & 3) + seed / 6) % 6]);
                if (i + 1 >= rounds) continue;
                sb.append(c[raw[2 * i + 1] >> 4 & 0xF]);
                sb.append('-');
                sb.append(c[raw[2 * i + 1] & 0xF]);
                seed = (seed * 5 + ((raw[2 * i] & 0xFF) * 7 + (raw[2 * i + 1] & 0xFF))) % 36;
                continue;
            }
            sb.append(v[seed % 6]);
            sb.append('x');
            sb.append(v[seed / 6]);
        }
        sb.append('x');
        return sb.toString();
    }

    public static String createHexFingerprint(String keytype, byte[] publickey) {
        byte[] raw = KnownHosts.rawFingerPrint("md5", keytype, publickey);
        return KnownHosts.rawToHexFingerprint(raw);
    }

    public static String createBubblebabbleFingerprint(String keytype, byte[] publickey) {
        byte[] raw = KnownHosts.rawFingerPrint("sha1", keytype, publickey);
        return KnownHosts.rawToBubblebabbleFingerprint(raw);
    }

    private class KnownHostsEntry {
        private final String[] patterns;
        private final PublicKey key;
        private final String algorithm;

        private KnownHostsEntry(String[] patterns, PublicKey key, String algorithm) {
            this.patterns = patterns;
            this.key = key;
            this.algorithm = algorithm;
        }
    }
}

