/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.tm4j.jenkins.utils;

import com.adaptavist.tm4j.jenkins.exception.InvalidJwtException;
import com.adaptavist.tm4j.jenkins.extensions.Instance;
import com.adaptavist.tm4j.jenkins.extensions.JiraCloudInstance;
import com.adaptavist.tm4j.jenkins.extensions.JiraServerInstance;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class FormHelper {
    public FormValidation testConnection(String serverAddress, String username, String password, String jwt, String type) {
        return "cloud".equals(type) ? this.testConnectionCloud(jwt) : this.testConnectionServer(serverAddress, username, password);
    }

    private FormValidation testConnectionServer(String serverAddress, String username, String password) {
        if (StringUtils.isBlank((String)(serverAddress = StringUtils.removeEnd((String)serverAddress, (String)"/")))) {
            return FormValidation.error((String)"Please enter the server name");
        }
        if (StringUtils.isBlank((String)username)) {
            return FormValidation.error((String)"Please enter the username");
        }
        if (StringUtils.isBlank((String)password)) {
            return FormValidation.error((String)"Please enter the password");
        }
        if (!serverAddress.trim().startsWith("https://") && !serverAddress.trim().startsWith("http://")) {
            return FormValidation.error((String)"Incorrect server address format");
        }
        if (!new JiraServerInstance(serverAddress, username, Secret.fromString((String)password)).isValidCredentials().booleanValue()) {
            return FormValidation.error((String)"Invalid credentials");
        }
        return FormValidation.ok((String)"The connection to Jira has been validated");
    }

    private FormValidation testConnectionCloud(String jwt) {
        try {
            JiraCloudInstance instance = new JiraCloudInstance(Secret.fromString((String)jwt));
            if (!instance.isValidCredentials().booleanValue()) {
                return FormValidation.error((String)"Invalid credentials");
            }
        }
        catch (InvalidJwtException e) {
            return FormValidation.error((String)"Invalid credentials");
        }
        return FormValidation.ok((String)"The connection to Jira has been validated");
    }

    public ListBoxModel fillServerAddressItems(List<Instance> jiraInstances) {
        ListBoxModel modelbox = new ListBoxModel();
        if (jiraInstances == null || jiraInstances.isEmpty()) {
            modelbox.add("Please configure at least one Jira instance in the global configuration");
            return modelbox;
        }
        for (Instance server : jiraInstances) {
            modelbox.add(server.name());
        }
        return modelbox;
    }

    public ListBoxModel fillFormat() {
        ListBoxModel modelbox = new ListBoxModel();
        modelbox.add("Cucumber");
        modelbox.add("Zephyr Output Result For JUnit");
        modelbox.add("JUnit XML Result File");
        return modelbox;
    }

    public FormValidation doCheckProjectKey(String projectKey) {
        return StringUtils.isBlank((String)projectKey) ? FormValidation.error((String)"Project key is required.") : FormValidation.ok();
    }

    public FormValidation doCheckFilePath(String filePath) {
        return StringUtils.isBlank((String)filePath) ? FormValidation.error((String)"File path is required.") : FormValidation.ok();
    }

    public FormValidation doCheckTargetPath(String fileTarget) {
        return StringUtils.isBlank((String)fileTarget) ? FormValidation.error((String)"File target is required.") : FormValidation.ok();
    }

    public FormValidation doCheckServerAddress(String serverAddress) {
        return StringUtils.isBlank((String)serverAddress) ? FormValidation.error((String)"Please enter the server name") : FormValidation.ok();
    }

    public FormValidation doCheckUsername(String userName) {
        return StringUtils.isBlank((String)userName) ? FormValidation.error((String)"Please enter the username") : FormValidation.ok();
    }

    public FormValidation doCheckPassword(String password) {
        return StringUtils.isBlank((String)password) ? FormValidation.error((String)"Please enter the password") : FormValidation.ok();
    }

    public FormValidation doCheckJwt(String jwt) {
        return StringUtils.isBlank((String)jwt) ? FormValidation.error((String)"Please enter the API key") : FormValidation.ok();
    }
}

