/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.tm4j.jenkins.extensions.postbuildactions;

import com.adaptavist.tm4j.jenkins.extensions.CustomTestCycle;
import com.adaptavist.tm4j.jenkins.extensions.ExpandedCustomTestCycle;
import com.adaptavist.tm4j.jenkins.extensions.Instance;
import com.adaptavist.tm4j.jenkins.extensions.configuration.Tm4jGlobalConfiguration;
import com.adaptavist.tm4j.jenkins.http.Tm4jJiraRestClient;
import com.adaptavist.tm4j.jenkins.utils.Constants;
import com.adaptavist.tm4j.jenkins.utils.FormHelper;
import com.adaptavist.tm4j.jenkins.utils.Validator;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileSystems;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

public class TestResultPublisher
extends Notifier
implements SimpleBuildStep {
    private final boolean customizeTestCycle;
    private final CustomTestCycle customTestCycle;
    private String serverAddress;
    private String projectKey;
    private String filePath;
    private String format;
    private Boolean autoCreateTestCases;

    @DataBoundConstructor
    public TestResultPublisher(String serverAddress, String projectKey, String filePath, Boolean autoCreateTestCases, String format, CustomTestCycle customTestCycle) {
        this.serverAddress = serverAddress;
        this.projectKey = projectKey;
        this.filePath = filePath;
        this.autoCreateTestCases = autoCreateTestCases;
        this.format = format;
        this.customizeTestCycle = customTestCycle != null;
        this.customTestCycle = customTestCycle;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull EnvVars envVars, @Nonnull Launcher launcher, TaskListener listener) {
        PrintStream logger = listener.getLogger();
        this.publishResults(logger, run, workspace, envVars);
    }

    private void publishResults(PrintStream logger, Run<?, ?> run, FilePath workspace, EnvVars envVars) {
        logger.printf("%s Publishing test results...%n", Constants.INFO);
        try {
            String directory = this.getDirectory(workspace, run);
            List<Instance> jiraInstances = this.getDescriptor().getJiraInstances();
            this.validateFieldsAndUploadResults(logger, envVars, jiraInstances, directory);
        }
        catch (Exception e) {
            this.handlePublishException(logger, run, e);
        }
    }

    private void handlePublishException(PrintStream logger, Run<?, ?> run, Exception exception) {
        run.setResult(Result.FAILURE);
        logger.printf("%s There was an error while publishing test results to Zephyr and they were not sent. Error details: %n", Constants.ERROR);
        throw new RuntimeException(exception);
    }

    private void validateFieldsAndUploadResults(PrintStream logger, EnvVars envVars, List<Instance> jiraInstances, String directory) throws Exception {
        this.validateFields();
        Tm4jJiraRestClient tm4jJiraRestClient = new Tm4jJiraRestClient(logger, jiraInstances, this.serverAddress);
        this.uploadResultsFile(tm4jJiraRestClient, directory, envVars);
    }

    private void validateFields() throws Exception {
        new Validator().validateProjectKey(this.projectKey).validateFilePath(this.filePath).validateFormat(this.format).validateServerAddress(this.serverAddress);
    }

    private void uploadResultsFile(Tm4jJiraRestClient tm4jJiraRestClient, String directory, EnvVars envVars) throws Exception {
        ExpandedCustomTestCycle expandedCustomTestCycle;
        ExpandedCustomTestCycle expandedCustomTestCycle2 = expandedCustomTestCycle = this.customizeTestCycle ? this.customTestCycle.expandEnvVars(envVars) : null;
        if ("Cucumber".equals(this.format)) {
            tm4jJiraRestClient.uploadCucumberFile(directory, this.filePath, this.projectKey, this.autoCreateTestCases, expandedCustomTestCycle);
            return;
        }
        if ("JUnit XML Result File".equals(this.format)) {
            tm4jJiraRestClient.uploadJUnitXmlResultFile(directory, this.filePath, this.projectKey, this.autoCreateTestCases, expandedCustomTestCycle);
            return;
        }
        tm4jJiraRestClient.uploadCustomFormatFile(directory, this.projectKey, this.autoCreateTestCases, expandedCustomTestCycle);
    }

    private String getDirectory(FilePath workspace, Run<?, ?> run) throws IOException, InterruptedException {
        String fileSeparator = FileSystems.getDefault().getSeparator();
        if (workspace.isRemote()) {
            FilePath path = new FilePath(run.getRootDir());
            workspace.copyRecursiveTo(this.filePath, path);
            return run.getRootDir() + fileSeparator;
        }
        return workspace.getRemote() + fileSeparator;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Boolean getAutoCreateTestCases() {
        return this.autoCreateTestCases;
    }

    public void setAutoCreateTestCases(Boolean autoCreateTestCases) {
        this.autoCreateTestCases = autoCreateTestCases;
    }

    public Boolean getCustomizeTestCycle() {
        return this.customizeTestCycle;
    }

    public String getName() {
        return this.customTestCycle.getName();
    }

    public String getDescription() {
        return this.customTestCycle.getDescription();
    }

    public String getJiraProjectVersion() {
        return this.customTestCycle.getJiraProjectVersion();
    }

    public String getFolderId() {
        return this.customTestCycle.getFolderId();
    }

    public String getCustomFields() {
        return this.customTestCycle.getCustomFields();
    }

    public CustomTestCycle getCustomTestCycle() {
        return this.customTestCycle;
    }

    @Symbol(value={"publishTestResults"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @Inject
        private Tm4jGlobalConfiguration tm4jGlobalConfiguration;

        public DescriptorImpl() {
            super(TestResultPublisher.class);
            this.load();
        }

        public Publisher newInstance(StaplerRequest request, @Nonnull JSONObject formData) throws Descriptor.FormException {
            return (Publisher)super.newInstance(request, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @Nonnull
        public String getDisplayName() {
            return "Zephyr: Publish Test Results";
        }

        public ListBoxModel doFillServerAddressItems() {
            return new FormHelper().fillServerAddressItems(this.getJiraInstances());
        }

        public ListBoxModel doFillFormatItems() {
            return new FormHelper().fillFormat();
        }

        @POST
        public FormValidation doCheckProjectKey(@QueryParameter String projectKey) {
            return new FormHelper().doCheckProjectKey(projectKey);
        }

        @POST
        public FormValidation doCheckFilePath(@QueryParameter String filePath) {
            return new FormHelper().doCheckFilePath(filePath);
        }

        List<Instance> getJiraInstances() {
            return this.tm4jGlobalConfiguration.getJiraInstances();
        }
    }
}

