/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.tm4j.jenkins.cucumber;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class CucumberReportParser {
    private final JsonReader reader;
    private final JsonWriter writer;

    public CucumberReportParser(JsonReader reader, JsonWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }

    public void parseFeatures() throws IOException {
        this.beginArray();
        while (this.reader.hasNext()) {
            this.parseFeature();
        }
        this.endArray();
    }

    private void parseFeature() throws IOException {
        this.beginObject();
        while (this.reader.hasNext()) {
            String tag = this.reader.nextName();
            if ("name".equals(tag)) {
                this.writer.name("name").value(this.nextString());
                continue;
            }
            if ("keyword".equals(tag)) {
                this.writer.name("keyword").value(this.nextString());
                continue;
            }
            if ("uri".equals(tag)) {
                this.writer.name("uri").value(this.nextString());
                continue;
            }
            if ("line".equals(tag)) {
                this.writer.name("line").value((Number)this.nextLong());
                continue;
            }
            if ("description".equals(tag)) {
                this.writer.name("description").value(this.nextString());
                continue;
            }
            if ("id".equals(tag)) {
                this.writer.name("id").value(this.nextString());
                continue;
            }
            if ("tags".equals(tag) && this.reader.peek() != JsonToken.NULL) {
                this.parseTags();
                continue;
            }
            if ("elements".equals(tag) && this.reader.peek() != JsonToken.NULL) {
                this.parseElements();
                continue;
            }
            this.reader.skipValue();
        }
        this.endObject();
    }

    private void parseTags() throws IOException {
        this.writer.name("tags");
        this.beginArray();
        while (this.reader.hasNext()) {
            this.parseTag();
        }
        this.endArray();
    }

    private void parseTag() throws IOException {
        this.beginObject();
        while (this.reader.hasNext()) {
            String tag = this.reader.nextName();
            if ("line".equals(tag)) {
                this.writer.name("line").value((Number)this.nextLong());
                continue;
            }
            if ("name".equals(tag)) {
                this.writer.name("name").value(this.nextString());
                continue;
            }
            this.reader.skipValue();
        }
        this.endObject();
    }

    private void parseElements() throws IOException {
        this.writer.name("elements");
        this.beginArray();
        while (this.reader.hasNext()) {
            this.parseElement();
        }
        this.endArray();
    }

    private void parseElement() throws IOException {
        this.beginObject();
        while (this.reader.hasNext()) {
            String tag = this.reader.nextName();
            if ("line".equals(tag)) {
                this.writer.name("line").value((Number)this.nextLong());
                continue;
            }
            if ("name".equals(tag)) {
                this.writer.name("name").value(this.nextString());
                continue;
            }
            if ("description".equals(tag)) {
                this.writer.name("description").value(this.nextString());
                continue;
            }
            if ("id".equals(tag)) {
                this.writer.name("id").value(this.nextString());
                continue;
            }
            if ("type".equals(tag)) {
                this.writer.name("type").value(this.nextString());
                continue;
            }
            if ("keyword".equals(tag)) {
                this.writer.name("keyword").value(this.nextString());
                continue;
            }
            if ("steps".equals(tag) && this.reader.peek() != JsonToken.NULL) {
                this.parseSteps();
                continue;
            }
            if ("tags".equals(tag) && this.reader.peek() != JsonToken.NULL) {
                this.parseTags();
                continue;
            }
            this.reader.skipValue();
        }
        this.endObject();
    }

    private void parseSteps() throws IOException {
        this.writer.name("steps");
        this.beginArray();
        while (this.reader.hasNext()) {
            this.parseStep();
        }
        this.endArray();
    }

    private void parseStep() throws IOException {
        this.beginObject();
        while (this.reader.hasNext()) {
            String tag = this.reader.nextName();
            if ("line".equals(tag)) {
                this.writer.name("line").value((Number)this.nextLong());
                continue;
            }
            if ("name".equals(tag)) {
                this.writer.name("name").value(this.nextString());
                continue;
            }
            if ("keyword".equals(tag)) {
                this.writer.name("keyword").value(this.nextString());
                continue;
            }
            if ("hidden".equals(tag)) {
                this.writer.name("hidden").value(this.reader.nextBoolean());
                continue;
            }
            if ("result".equals(tag)) {
                this.writer.name("result");
                this.parseResult();
                continue;
            }
            this.reader.skipValue();
        }
        this.endObject();
    }

    private void parseResult() throws IOException {
        this.beginObject();
        while (this.reader.hasNext()) {
            String tag = this.reader.nextName();
            if ("status".equals(tag)) {
                this.writer.name("status").value(this.nextString());
                continue;
            }
            if ("duration".equals(tag)) {
                this.writer.name("duration").value((Number)this.nextLong());
                continue;
            }
            if ("error_message".equals(tag)) {
                this.writer.name("error_message").value(this.nextString());
                continue;
            }
            this.reader.skipValue();
        }
        this.endObject();
    }

    private Long nextLong() throws IOException {
        if (this.reader.peek() != JsonToken.NULL) {
            return this.reader.nextLong();
        }
        this.reader.nextNull();
        return null;
    }

    private String nextString() throws IOException {
        if (this.reader.peek() != JsonToken.NULL) {
            return this.reader.nextString();
        }
        this.reader.nextNull();
        return null;
    }

    private void beginObject() throws IOException {
        this.reader.beginObject();
        this.writer.beginObject();
    }

    private void endObject() throws IOException {
        this.reader.endObject();
        this.writer.endObject();
    }

    private void beginArray() throws IOException {
        this.reader.beginArray();
        this.writer.beginArray();
    }

    private void endArray() throws IOException {
        this.writer.endArray();
        this.reader.endArray();
    }
}

