/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.tm4j.jenkins.cucumber;

import com.adaptavist.tm4j.jenkins.cucumber.CucumberReportParser;
import com.adaptavist.tm4j.jenkins.utils.Constants;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;

public class CucumberFileProcessor {
    private final PrintStream logger;
    private String tmpDirectory;

    public CucumberFileProcessor(PrintStream logger, String directory) {
        this.logger = logger;
        this.tmpDirectory = CucumberFileProcessor.getTmpDirectory(directory);
    }

    public File filterCucumberFile(File file) {
        return this.filterCucumberFile(file, false);
    }

    private static String getTmpDirectory(String directory) {
        String fileSeparator = FileSystems.getDefault().getSeparator();
        String tmpDirectoryName = directory + (directory.endsWith(fileSeparator) ? "" : fileSeparator);
        return tmpDirectoryName + "target" + fileSeparator + "cucumber_tmp" + fileSeparator;
    }

    void setTmpDirectory(String directory) {
        this.tmpDirectory = directory;
    }

    @VisibleForTesting
    File filterCucumberFile(File file, boolean withFormat) {
        File directory = new File(this.tmpDirectory);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new RuntimeException(String.format("The directory '%s' couldn't be created. Please check folder permissions and try again", this.tmpDirectory));
        }
        File newFile = new File(this.tmpDirectory + file.getName());
        try {
            FileInputStream in = new FileInputStream(file);
            try (JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));){
                FileOutputStream out = new FileOutputStream(newFile);
                try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));){
                    if (withFormat) {
                        writer.setIndent("  ");
                    }
                    CucumberReportParser parser = new CucumberReportParser(reader, writer);
                    parser.parseFeatures();
                }
            }
            return newFile;
        }
        catch (IOException | IllegalStateException exception) {
            this.deleteTmpFileAfterError(newFile);
            throw new RuntimeException(String.format("Exception while parsing file: %s ", file.getName()), exception);
        }
    }

    private void deleteTmpFileAfterError(File file) {
        if (file.exists() && !file.delete()) {
            this.logger.printf("%s The generated file couldn't be deleted after error. Please check folder permissions and delete the file manually: %s %n", Constants.INFO, file.getAbsolutePath());
        }
    }

    public void deleteTmpFilesAndFolder() {
        File directoryFile = new File(this.tmpDirectory);
        File[] allContents = directoryFile.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                if (file.delete()) continue;
                this.logger.printf("%s The generated file couldn't be deleted. Please check folder permissions and delete the file manually: %s %n", Constants.INFO, file.getAbsolutePath());
            }
        }
        if (!directoryFile.delete()) {
            this.logger.printf("%s The generated directory couldn't be deleted. Please check folder permissions and delete the directory manually: %s %n", Constants.INFO, directoryFile.getAbsolutePath());
        }
    }
}

