/*
 * Decompiled with CFR 0.152.
 */
package com.delinea.server.spring;

import com.delinea.platform.service.AuthenticationService;
import com.delinea.server.spring.AuthenticationModel;
import com.delinea.server.spring.SecretServer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.HttpHost;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.InterceptingClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriTemplateHandler;

@Component
public class SecretServerFactoryBean
implements FactoryBean<SecretServer>,
InitializingBean {
    private static final String GRANT_REQUEST_USERNAME_PROPERTY = "username";
    private static final String GRANT_REQUEST_PASSWORD_PROPERTY = "password";
    private static final String GRANT_REQUEST_GRANT_TYPE_PROPERTY = "grant_type";
    private static final String GRANT_REQUEST_GRANT_TYPE = "password";
    private static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    private static final String AUTHORIZATION_TOKEN_TYPE = "Bearer";
    private String API_VERSION;
    private String ruleName;
    private String onboardingKey;
    private int authenticationMode;
    private String clientId;
    private String clientSecret;
    private String serverUrl;
    private String secreterverUrl;
    private String serverUsername;
    private String serverPassword;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    @Autowired(required=false)
    private ClientHttpRequestFactory requestFactory;
    @Autowired
    private Environment environment;
    @Autowired
    private AuthenticationService authenticationService;
    private static final int SDK_CLIENT_AUTH_MODE = 1;
    private static final int DEFAULT_AUTH_MODE = 0;

    public void afterPropertiesSet() throws Exception {
        String authModeStr = this.environment.getProperty("authentication_mode");
        this.authenticationMode = StringUtils.hasText((String)authModeStr) ? Integer.parseInt(authModeStr) : 0;
        String apiVersionProp = this.environment.getProperty("api.version");
        String string = this.API_VERSION = apiVersionProp != null && !apiVersionProp.isEmpty() ? apiVersionProp : "v1";
        if (this.authenticationMode == 0) {
            this.serverUsername = this.environment.getProperty("server.username");
            this.serverPassword = this.environment.getProperty("server.password");
            Assert.state((StringUtils.hasText((String)this.serverUsername) && StringUtils.hasText((String)this.serverPassword) ? 1 : 0) != 0, (String)"server.username and secret.password must be set when authenticationMode is 0");
        } else if (this.authenticationMode == 1) {
            this.ruleName = this.environment.getProperty("rule.name");
            this.onboardingKey = this.environment.getProperty("onboarding.key");
            Assert.state((StringUtils.hasText((String)this.ruleName) && StringUtils.hasText((String)this.onboardingKey) ? 1 : 0) != 0, (String)"rule.name and onboarding.key must be set when authenticationMode is 1");
        }
        this.serverUrl = this.environment.getProperty("server.url");
        Assert.state((boolean)StringUtils.hasText((String)this.serverUrl), (String)"server.url must be set.");
        this.proxyHost = this.environment.getProperty("proxy.host");
        this.proxyPort = this.environment.getProperty("proxy.port");
        this.proxyUsername = this.environment.getProperty("proxy.username");
        this.proxyPassword = this.environment.getProperty("proxy.password");
        if (this.requestFactory == null) {
            this.requestFactory = this.createRequestFactoryWithProxy();
        }
        if (this.authenticationService != null) {
            RestTemplate proxyRestTemplate = new RestTemplate(this.requestFactory);
            this.authenticationService.setRestTemplate(proxyRestTemplate);
        }
    }

    private ClientHttpRequestFactory createRequestFactoryWithProxy() {
        if (!StringUtils.hasText((String)this.proxyHost)) {
            System.out.println("[INFO] No proxy configured \u2014 using direct connection.");
            return new SimpleClientHttpRequestFactory();
        }
        int port = -1;
        try {
            port = Integer.parseInt(this.proxyPort);
        }
        catch (Exception e) {
            System.out.println("[WARN] Invalid proxy port: " + this.proxyPort + " \u2014 using direct connection.");
            return new SimpleClientHttpRequestFactory();
        }
        if (port <= 0) {
            System.out.println("[WARN] Proxy port not valid (" + this.proxyPort + ") \u2014 using direct connection.");
            return new SimpleClientHttpRequestFactory();
        }
        HttpHost proxy = new HttpHost(this.proxyHost, port);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        if (StringUtils.hasText((String)this.proxyUsername)) {
            credsProvider.setCredentials(new AuthScope(this.proxyHost, port), (Credentials)new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword.toCharArray()));
        }
        RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).addRequestInterceptorLast((request, entity, context) -> {}).build();
        return new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
    }

    private AccessGrant getAccessGrant() throws UnknownHostException, UnsupportedEncodingException, Exception {
        if (this.authenticationMode == 0) {
            AuthenticationModel authenticationModel = this.isPlatfromOrSS();
            if (authenticationModel.isPlatformLogin()) {
                AccessGrant accessGrant = new AccessGrant();
                accessGrant.accessToken = authenticationModel.getToken();
                this.secreterverUrl = authenticationModel.getVaultURL();
                return accessGrant;
            }
            return this.getTokenUsingSScred();
        }
        this.secreterverUrl = this.serverUrl;
        this.setSDKClientCred();
        return this.getTokenUsingSDKClient();
    }

    private AuthenticationModel isPlatfromOrSS() throws Exception {
        AuthenticationModel authenticationModel = this.authenticationService.authenticateAsync(new AuthenticationModel(this.serverUsername, this.serverPassword, this.serverUrl));
        if (authenticationModel.isPlatformLogin()) {
            return authenticationModel;
        }
        this.secreterverUrl = this.serverUrl;
        return authenticationModel;
    }

    private AccessGrant getTokenUsingSScred() {
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.add((Object)GRANT_REQUEST_USERNAME_PROPERTY, (Object)this.serverUsername);
        request.add((Object)"password", (Object)this.serverPassword);
        request.add((Object)GRANT_REQUEST_GRANT_TYPE_PROPERTY, (Object)"password");
        RestTemplate rt = new RestTemplate(this.requestFactory);
        return (AccessGrant)rt.postForObject(this.secreterverUrl + "/oauth2/token".replaceAll("/*$", ""), (Object)request, AccessGrant.class, new Object[0]);
    }

    private AccessGrant getTokenUsingSDKClient() throws UnsupportedEncodingException {
        String body = "client_id=sdk-client-" + URLEncoder.encode(this.clientId, StandardCharsets.UTF_8.toString()) + "&client_secret=" + URLEncoder.encode(this.clientSecret, StandardCharsets.UTF_8.toString()) + "&grant_type=client_credentials";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity entity = new HttpEntity((Object)body, (MultiValueMap)headers);
        RestTemplate rt = new RestTemplate(this.requestFactory);
        ResponseEntity response = rt.exchange(this.serverUrl + "/oauth2/token", HttpMethod.POST, entity, AccessGrant.class, new Object[0]);
        if (response.getStatusCode() == HttpStatus.OK) {
            return (AccessGrant)response.getBody();
        }
        return null;
    }

    private void setSDKClientCred() throws UnknownHostException {
        Map responseBody;
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("Description", String.format("Machine: %s, OS: %s - %s %s", InetAddress.getLocalHost().getHostName(), System.getProperty("os.arch"), System.getProperty("java.version"), System.getProperty("sun.arch.data.model")));
        payload.put("Name", InetAddress.getLocalHost().getHostName());
        payload.put("OnboardingKey", this.onboardingKey);
        payload.put("RuleName", this.ruleName);
        payload.put("ClientId", UUID.randomUUID().toString());
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/json");
        HttpEntity entity = new HttpEntity(payload, (MultiValueMap)headers);
        RestTemplate rt = new RestTemplate(this.requestFactory);
        ResponseEntity response = rt.exchange(this.serverUrl + "/api/" + this.API_VERSION + "/sdk-client-accounts", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){}, new Object[0]);
        if (response.getStatusCode() == HttpStatus.OK && (responseBody = (Map)response.getBody()) != null) {
            this.clientId = (String)responseBody.get("clientId");
            this.clientSecret = (String)responseBody.get("clientSecret");
        }
    }

    public SecretServer getObject() throws Exception {
        AccessGrant accessGrant = this.getAccessGrant();
        SecretServer secretServer = new SecretServer();
        secretServer.setUriTemplateHandler((UriTemplateHandler)new DefaultUriBuilderFactory(this.secreterverUrl + "/api/" + this.API_VERSION));
        secretServer.setRequestFactory((ClientHttpRequestFactory)new InterceptingClientHttpRequestFactory(this.requestFactory, Arrays.asList((request, body, execution) -> {
            request.getHeaders().add(AUTHORIZATION_HEADER_NAME, String.format("%s %s", AUTHORIZATION_TOKEN_TYPE, accessGrant.accessToken));
            return execution.execute(request, body);
        })));
        return secretServer;
    }

    public Class<?> getObjectType() {
        return SecretServer.class;
    }

    static class AccessGrant {
        private String accessToken;
        private String refreshToken;
        private String tokenType;
        private int expiresIn;

        AccessGrant() {
        }

        @JsonProperty(value="access_token")
        public String getAccessToken() {
            return this.accessToken;
        }

        @JsonProperty(value="expires_in")
        public int getExpiresIn() {
            return this.expiresIn;
        }

        @JsonProperty(value="refresh_token")
        public String getRefreshToken() {
            return this.refreshToken;
        }

        @JsonProperty(value="token_type")
        public String getTokenType() {
            return this.tokenType;
        }
    }
}

