/*
 * Decompiled with CFR 0.152.
 */
package com.delinea.server.spring;

import com.delinea.server.spring.Secret;
import java.util.HashMap;
import org.springframework.web.client.RestTemplate;

public class SecretServer
extends RestTemplate {
    private static final String SECRET_ID_URI = "/secrets/{id}";
    private static final String SECRET_FILE_ATTACHMENT_URI = "/secrets/{id}/fields/{slug}";

    public Secret getSecret(int id, boolean fetchFileAttachments) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", String.valueOf(id));
        Secret secret = (Secret)this.getForObject(SECRET_ID_URI, Secret.class, params);
        if (fetchFileAttachments) {
            secret.getFields().forEach(field -> {
                if (field.getFileAttachmentId() > 0) {
                    params.put("slug", field.getSlug());
                    field.setValue((String)this.getForEntity(SECRET_FILE_ATTACHMENT_URI, String.class, params).getBody());
                }
            });
        }
        return secret;
    }

    public Secret getSecret(int id) {
        return this.getSecret(id, true);
    }
}

