/*
 * Decompiled with CFR 0.152.
 */
package com.delinea.secrets.spring;

import com.delinea.server.spring.SecretServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;

@SpringBootApplication
@ComponentScan(value={"com.delinea.platform.model", "com.delinea.platform.service", "com.delinea.server.spring"})
public class Application {
    private final Logger log = LoggerFactory.getLogger(Application.class);
    @Value(value="${secret.id:#null}")
    private String secretId;

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }

    @Bean
    public CommandLineRunner runServer(SecretServer secretServer) throws Exception {
        return args -> this.log.info("Running with args: \"{}\"; getSecret({}) -> {}", new Object[]{args, this.secretId, secretServer.getSecret(Integer.parseInt(this.secretId)).toString()});
    }
}

