/*
 * Decompiled with CFR 0.152.
 */
package com.delinea.platform.service;

import com.delinea.platform.model.OAuthTokens;
import com.delinea.platform.model.VaultsResponseModel;
import com.delinea.server.spring.AuthenticationModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class PlatformLogin {
    private RestTemplate restTemplate;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="RestTemplate is a Spring-managed immutable bean and safe to assign directly.")
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public AuthenticationModel platformAuthentication(AuthenticationModel authModel) throws Exception {
        try {
            ResponseEntity<String> tokenResponse = this.getAccessToken(authModel);
            if (tokenResponse.getStatusCode() != HttpStatus.OK) {
                return this.handleErrorResponse((String)tokenResponse.getBody());
            }
            OAuthTokens authResponse = (OAuthTokens)new ObjectMapper().readValue((String)tokenResponse.getBody(), OAuthTokens.class);
            if (authResponse == null) {
                return this.handleErrorResponse("Unable to authenticate for user " + authModel.getUserName() + " on server " + authModel.getServerURL());
            }
            authModel.setToken(authResponse.getAccessToken());
            authModel.setTokenExpiration(ZonedDateTime.now().plusSeconds(authResponse.getExpiresIn()));
            ResponseEntity<String> vaultResponse = this.getVault(authModel, authResponse.getAccessToken());
            if (vaultResponse.getStatusCode() != HttpStatus.OK) {
                return this.handleErrorResponse((String)vaultResponse.getBody());
            }
            VaultsResponseModel vResponse = (VaultsResponseModel)new ObjectMapper().readValue((String)vaultResponse.getBody(), VaultsResponseModel.class);
            if (vResponse == null) {
                return this.handleErrorResponse("Unable to fetch vaults from server " + authModel.getServerURL());
            }
            Optional<VaultsResponseModel.Vault> vault = vResponse.getVaults().stream().filter(x -> x.isDefault() && x.isActive()).findFirst();
            if (!vault.isPresent()) {
                return this.handleErrorResponse("Unable to fetch vaults from server " + authModel.getServerURL());
            }
            authModel.setVaultURL(vault.get().getConnection().getUrl());
            authModel.setVaultType(vault.get().getType());
            return authModel;
        }
        catch (Exception ex) {
            throw new Exception("Error occurred in PlatformAuthentication:\n" + ex.getMessage(), ex);
        }
    }

    private AuthenticationModel handleErrorResponse(String errorMessage) {
        return new AuthenticationModel(errorMessage, true);
    }

    private ResponseEntity<String> getAccessToken(AuthenticationModel authModel) {
        String apiUrl = authModel.getServerURL().replaceAll("/$", "") + "/identity/api/oauth2/token/xpmplatform";
        String scope = "xpmheadless";
        if (authModel.getServerURL() == null) {
            throw new IllegalArgumentException("Missing required environment variables");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"grant_type", (Object)"client_credentials");
        body.add((Object)"client_id", (Object)authModel.getUserName());
        body.add((Object)"client_secret", (Object)authModel.getPassword());
        body.add((Object)"scope", (Object)scope);
        HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        return this.restTemplate.exchange(apiUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]);
    }

    public ResponseEntity<String> getVault(AuthenticationModel authModel, String token) {
        String apiUrl = authModel.getServerURL().replaceAll("/$", "") + "/vaultbroker/api/vaults";
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + token);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return this.restTemplate.exchange(apiUrl, HttpMethod.GET, requestEntity, String.class, new Object[0]);
    }
}

