/*
 * Decompiled with CFR 0.152.
 */
package com.delinea.platform.service;

import com.delinea.platform.model.ServerResponseModel;
import com.delinea.platform.service.IAuthenticationService;
import com.delinea.platform.service.PlatformLogin;
import com.delinea.server.spring.AuthenticationModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class AuthenticationService
implements IAuthenticationService {
    private RestTemplate restTemplate;
    private PlatformLogin platformLogin = new PlatformLogin();

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="RestTemplate is a Spring-managed immutable bean and safe to assign directly.")
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.platformLogin.setRestTemplate(restTemplate);
    }

    @Override
    public AuthenticationModel authenticateAsync(AuthenticationModel authModel) throws Exception {
        try {
            String platformHealthCheckUrl = authModel.getServerURL().replaceFirst("/$", "") + "/health";
            String ssHealthCheckUrl = authModel.getServerURL().replaceFirst("/$", "") + "/api/v1/healthcheck";
            boolean isSsHealthy = this.checkJsonResponseAsync(ssHealthCheckUrl);
            if (isSsHealthy) {
                authModel.setPlatformLogin(false);
            } else {
                boolean isPlatformHealthy = this.checkJsonResponseAsync(platformHealthCheckUrl);
                if (isPlatformHealthy) {
                    authModel.setPlatformLogin(true);
                    return this.platformLogin.platformAuthentication(authModel);
                }
            }
            return authModel;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private boolean checkJsonResponseAsync(String url) throws IOException {
        try {
            ResponseEntity response = this.restTemplate.getForEntity(url, String.class, new Object[0]);
            if (response.getStatusCode() != HttpStatus.OK) {
                return false;
            }
            String responseBody = (String)response.getBody();
            if (responseBody != null && !responseBody.isEmpty()) {
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    ServerResponseModel jsonResponse = (ServerResponseModel)objectMapper.readValue(responseBody, ServerResponseModel.class);
                    return jsonResponse != null && jsonResponse.isHealthy();
                }
                catch (IOException e) {
                    return responseBody.contains("Healthy");
                }
            }
            return false;
        }
        catch (HttpClientErrorException e) {
            return false;
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }
}

