/*
 * Decompiled with CFR 0.152.
 */
package com.delinea.secrets.jenkins.wrapper.cred;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.delinea.secrets.jenkins.wrapper.cred.ServerConfiguration;
import com.delinea.secrets.jenkins.wrapper.cred.UserCredentials;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class ServerSecret
extends AbstractDescribableImpl<ServerSecret> {
    private final int id;
    private final List<Mapping> mappings;
    private String baseUrl;
    private String credentialId;

    public int getId() {
        return this.id;
    }

    public List<Mapping> getMappings() {
        return this.mappings;
    }

    @DataBoundConstructor
    public ServerSecret(int id, List<Mapping> mappings) {
        this.id = id;
        this.mappings = mappings;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @DataBoundSetter
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    @DataBoundSetter
    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    @Extension
    @Symbol(value={"secretServerSecret"})
    public static final class DescriptorImpl
    extends Descriptor<ServerSecret> {
        public String getDisplayName() {
            return "Secret Server Secret";
        }

        @POST
        public FormValidation doCheckCredentialId(@QueryParameter String value) throws IOException, ServletException {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.error((String)"You do not have permission to perform this action");
            }
            if (StringUtils.isBlank((String)value) && StringUtils.isBlank((String)ServerConfiguration.get().getCredentialId())) {
                return FormValidation.error((String)"Credentials are required");
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item item) {
            if (item == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || item != null && !item.hasPermission(Item.CONFIGURE)) {
                return new StandardListBoxModel();
            }
            return new StandardListBoxModel().includeAs(ACL.SYSTEM, item, UserCredentials.class).includeEmptyValue();
        }

        @POST
        public FormValidation doCheckId(@QueryParameter String value) throws IOException, ServletException {
            try {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                    return FormValidation.error((String)"You do not have permission to perform this action");
                }
                Integer.parseInt(value);
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Secret ID is an integer");
            }
        }

        @POST
        public FormValidation doCheckBaseUrl(@QueryParameter String value) throws IOException, ServletException {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.error((String)"You do not have permission to perform this action");
            }
            if (StringUtils.isBlank((String)value) && StringUtils.isNotBlank((String)ServerConfiguration.get().getBaseUrl())) {
                return FormValidation.ok();
            }
            return ServerConfiguration.checkBaseUrl(value);
        }
    }

    public static class Mapping
    extends AbstractDescribableImpl<Mapping> {
        private final String environmentVariable;
        private final String field;

        public String getEnvironmentVariable() {
            return this.environmentVariable;
        }

        public String getField() {
            return this.field;
        }

        @DataBoundConstructor
        public Mapping(String environmentVariable, String field) {
            this.environmentVariable = environmentVariable;
            this.field = field;
        }

        @Extension
        public static final class DescriptorImpl
        extends Descriptor<Mapping> {
            private static final String NAME_PATTERN = "[a-zA-Z_-][a-zA-Z0-9 ]*";

            public String getDisplayName() {
                return "Secret Field to Environment Variable Mapping";
            }

            private FormValidation checkPattern(String value, String name) {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                    return FormValidation.error((String)"You do not have permission to perform this action");
                }
                if (Pattern.matches(NAME_PATTERN, value)) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)String.format("%s must match %s", name, NAME_PATTERN));
            }

            @POST
            public FormValidation doCheckEnvironmentVariable(@QueryParameter String value) throws IOException, ServletException {
                return this.checkPattern(value, "Environment Variable");
            }

            @POST
            public FormValidation doCheckField(@QueryParameter String value) throws IOException, ServletException {
                return this.checkPattern(value, "Field Name");
            }
        }
    }
}

