/*
 * Decompiled with CFR 0.152.
 */
package org.yakshna.testwheel.apiplugin;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.Secret;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.jenkinsci.Symbol;
import org.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;

public class TestWheelTrigger
extends Builder
implements SimpleBuildStep {
    private final Secret apiKey;
    private final Secret prjctKey;
    private static String url = "https://app.testwheel.com/test-appln";
    private static final String STATUS = "status";

    @DataBoundConstructor
    public TestWheelTrigger(Secret apiKey, Secret prjctKey) {
        this.apiKey = apiKey;
        this.prjctKey = prjctKey;
    }

    public Secret getApiKey() {
        return this.apiKey;
    }

    public Secret getPrjctKey() {
        return this.prjctKey;
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) {
        block24: {
            try (CloseableHttpClient client = this.createHttpClientWithProxy();){
                JSONObject requestBody = new JSONObject();
                String decryptedApiKey = this.apiKey.getPlainText();
                String decryptedPrjctKey = this.prjctKey.getPlainText();
                requestBody.put("apiKey", (Object)decryptedApiKey);
                requestBody.put("prjctKey", (Object)decryptedPrjctKey);
                HttpPost request = new HttpPost(url);
                request.setHeader("Content-Type", (Object)"application/json");
                request.setEntity((HttpEntity)new StringEntity(requestBody.toString()));
                HttpClientResponseHandler<String> responseHandler = new HttpClientResponseHandler<String>(){

                    public String handleResponse(ClassicHttpResponse response) throws HttpException, IOException {
                        return EntityUtils.toString((HttpEntity)response.getEntity());
                    }
                };
                String responseBody = (String)client.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)responseHandler);
                JSONObject jsonResponse = new JSONObject(responseBody);
                if ("success".equalsIgnoreCase(jsonResponse.getString(STATUS))) {
                    String runId = jsonResponse.getString("output");
                    if (runId != null && !runId.isEmpty()) {
                        JSONObject secondRequestBody = new JSONObject();
                        secondRequestBody.put("apiKey", (Object)decryptedApiKey);
                        secondRequestBody.put("prjctKey", (Object)decryptedPrjctKey);
                        secondRequestBody.put("runId", (Object)runId);
                        HttpPost secondRequest = new HttpPost(url);
                        secondRequest.setHeader("Content-Type", (Object)"application/json");
                        secondRequest.setEntity((HttpEntity)new StringEntity(secondRequestBody.toString()));
                        while (true) {
                            String secondResponseBody;
                            JSONObject secondJsonResponse;
                            if ("SUCCESS".equalsIgnoreCase((secondJsonResponse = new JSONObject(secondResponseBody = (String)client.execute((ClassicHttpRequest)secondRequest, (HttpClientResponseHandler)responseHandler))).getString(STATUS))) {
                                String reportUrl = secondJsonResponse.getString("output");
                                listener.getLogger().println("Downloading report from: " + reportUrl);
                                HttpGet reportRequest = new HttpGet(reportUrl);
                                HttpClientResponseHandler<InputStream> reportResponseHandler = new HttpClientResponseHandler<InputStream>(){

                                    public InputStream handleResponse(ClassicHttpResponse response) throws HttpException, IOException {
                                        return response.getEntity().getContent();
                                    }
                                };
                                InputStream reportStream = (InputStream)client.execute((ClassicHttpRequest)reportRequest, (HttpClientResponseHandler)reportResponseHandler);
                                FilePath reportFilePath = workspace.child("report.pdf");
                                try (OutputStream fos = reportFilePath.write();){
                                    int len;
                                    byte[] buffer = new byte[1024];
                                    while ((len = reportStream.read(buffer)) != -1) {
                                        fos.write(buffer, 0, len);
                                    }
                                }
                                listener.getLogger().println("Report downloaded successfully: " + reportFilePath.getRemote());
                                run.setResult(Result.SUCCESS);
                                return;
                            }
                            if ("FAILURE".equalsIgnoreCase(secondJsonResponse.getString(STATUS))) {
                                listener.getLogger().println("API Test failed");
                                run.setResult(Result.FAILURE);
                                return;
                            }
                            Thread.sleep(20000L);
                        }
                    }
                    listener.getLogger().println("Output not found in the response");
                    run.setResult(Result.FAILURE);
                    break block24;
                }
                listener.getLogger().println("API Request failed. Please Check the API URL");
                run.setResult(Result.FAILURE);
            }
            catch (IOException e) {
                listener.getLogger().println("Error: " + e.getMessage());
                run.setResult(Result.FAILURE);
            }
            catch (InterruptedException e) {
                listener.getLogger().println("InterruptedException occurred: " + e.getMessage());
                run.setResult(Result.FAILURE);
                Thread.currentThread().interrupt();
            }
        }
    }

    private CloseableHttpClient createHttpClientWithProxy() {
        Jenkins jenkins = Jenkins.get();
        ProxyConfiguration proxyConfig = jenkins.proxy;
        if (proxyConfig != null) {
            HttpHost proxy = new HttpHost(proxyConfig.name, proxyConfig.port);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            if (proxyConfig.getUserName() != null && proxyConfig.getSecretPassword() != null) {
                String decryptedPassword = Secret.toString((Secret)proxyConfig.getSecretPassword());
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyConfig.getUserName(), decryptedPassword.toCharArray());
                credentialsProvider.setCredentials(new AuthScope(proxyConfig.name, proxyConfig.port), (Credentials)credentials);
            }
            return HttpClients.custom().setProxy(proxy).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        }
        return HttpClients.createDefault();
    }

    @Extension
    @Symbol(value={"testwheelTrigger"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "TestwheelTrigger";
        }
    }
}

