/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.results;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import hudson.plugins.testng.results.BaseResult;
import hudson.plugins.testng.results.ClassResult;
import hudson.plugins.testng.results.MethodResult;
import hudson.plugins.testng.results.PackageResult;
import hudson.plugins.testng.results.TestNGTestResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kohsuke.stapler.export.Exported;

@SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="ArrayList is Serializable")
public class TestNGResult
extends BaseResult
implements Serializable {
    private static final long serialVersionUID = -3491974223665601995L;
    private List<TestNGTestResult> testList = new ArrayList<TestNGTestResult>();
    private List<MethodResult> passedTests = new ArrayList<MethodResult>();
    private List<MethodResult> failedTests = new ArrayList<MethodResult>();
    private List<MethodResult> skippedTests = new ArrayList<MethodResult>();
    private List<MethodResult> failedConfigurationMethods = new ArrayList<MethodResult>();
    private List<MethodResult> skippedConfigurationMethods = new ArrayList<MethodResult>();
    private long startTime;
    private long endTime;
    private int passCount;
    private int failCount;
    private int skipCount;
    private int failedConfigCount;
    private int skippedConfigCount;
    private Map<String, PackageResult> packageMap = new HashMap<String, PackageResult>();

    @Deprecated
    public TestNGResult(String name) {
        super("testngreports");
    }

    public TestNGResult() {
        super("testngreports");
    }

    @Override
    public String getTitle() {
        return this.getDisplayName();
    }

    public List<MethodResult> getFailedTests() {
        return this.failedTests;
    }

    public List<MethodResult> getPassedTests() {
        return this.passedTests;
    }

    public List<MethodResult> getSkippedTests() {
        return this.skippedTests;
    }

    public List<MethodResult> getFailedConfigs() {
        return this.failedConfigurationMethods;
    }

    public List<MethodResult> getSkippedConfigs() {
        return this.skippedConfigurationMethods;
    }

    public int getPassCount() {
        return this.passCount;
    }

    @Exported
    public int getFailCount() {
        return this.failCount;
    }

    @Exported
    public int getSkipCount() {
        return this.skipCount;
    }

    public List<TestNGTestResult> getTestList() {
        return this.testList;
    }

    @Exported(name="total")
    public int getTotalCount() {
        return super.getTotalCount();
    }

    @Exported
    public float getDuration() {
        return (float)(this.endTime - this.startTime) / 1000.0f;
    }

    @Exported(name="fail-config")
    public int getFailedConfigCount() {
        return this.failedConfigCount;
    }

    @Exported(name="skip-config")
    public int getSkippedConfigCount() {
        return this.skippedConfigCount;
    }

    @Exported(name="package")
    public Collection<PackageResult> getPackageList() {
        return this.packageMap.values();
    }

    public Map<String, PackageResult> getPackageMap() {
        return this.packageMap;
    }

    public Set<String> getPackageNames() {
        return this.packageMap.keySet();
    }

    public void addUniqueTests(List<TestNGTestResult> testList) {
        HashSet<TestNGTestResult> tmpSet = new HashSet<TestNGTestResult>(this.testList);
        tmpSet.addAll(testList);
        this.testList = new ArrayList<TestNGTestResult>(tmpSet);
    }

    @Override
    public void setRun(Run<?, ?> run) {
        this.run = run;
        for (PackageResult pkg : this.packageMap.values()) {
            pkg.setRun(run);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestNGResult testngResult = (TestNGResult)o;
        return this.run == null ? testngResult.run == null : this.run.equals(testngResult.run);
    }

    public int hashCode() {
        int result = this.run != null ? this.run.hashCode() : 0;
        return result;
    }

    public String toString() {
        return "TestNGResult {totalTests=%d, failedTests=%d, skippedTests=%d, failedConfigs=%d, skippedConfigs=%d}".formatted(this.passCount + this.failCount + this.skipCount, this.failCount, this.skipCount, this.failedConfigCount, this.skippedConfigCount);
    }

    public void tally() {
        this.failedConfigCount = this.failedConfigurationMethods.size();
        this.skippedConfigCount = this.skippedConfigurationMethods.size();
        this.failCount = this.failedTests.size();
        this.passCount = this.passedTests.size();
        this.skipCount = this.skippedTests.size();
        this.packageMap.clear();
        for (TestNGTestResult _test : this.testList) {
            for (ClassResult _class : _test.getClassList()) {
                String pkg = _class.getPkgName();
                if (this.packageMap.containsKey(pkg)) {
                    Collection classResults = this.packageMap.get(pkg).getChildren();
                    if (classResults.contains(_class)) continue;
                    classResults.add(_class);
                    continue;
                }
                PackageResult tpkg = new PackageResult(pkg);
                tpkg.getChildren().add(_class);
                tpkg.setParent(this);
                this.packageMap.put(pkg, tpkg);
            }
        }
        this.startTime = Long.MAX_VALUE;
        this.endTime = 0L;
        for (PackageResult pkgResult : this.packageMap.values()) {
            pkgResult.tally();
            if (this.startTime > pkgResult.getStartTime()) {
                this.startTime = pkgResult.getStartTime();
            }
            if (this.endTime >= pkgResult.getEndTime()) continue;
            this.endTime = pkgResult.getEndTime();
        }
    }

    @Override
    @Exported(visibility=999)
    public String getName() {
        return this.name;
    }

    @Override
    public BaseResult getParent() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    public Collection<PackageResult> getChildren() {
        return this.packageMap.values();
    }

    public boolean hasChildren() {
        return !this.packageMap.isEmpty();
    }
}

