/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.results;

import hudson.model.Run;
import hudson.plugins.testng.TestNGTestResultBuildAction;
import hudson.plugins.testng.results.BaseResult;
import hudson.plugins.testng.results.ClassResult;
import hudson.plugins.testng.results.MethodResultException;
import hudson.plugins.testng.results.PackageResult;
import hudson.plugins.testng.results.TestNGResult;
import hudson.plugins.testng.util.GraphHelper;
import hudson.tasks.test.TestResult;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.verb.POST;

public class MethodResult
extends BaseResult {
    private String status;
    private String description;
    private boolean isConfig;
    private float duration;
    private MethodResultException exception;
    private long startedAt;
    private long endedAt;
    private String testInstanceName;
    private String parentTestName;
    private String parentSuiteName;
    private List<String> groups;
    private List<String> parameters;
    private String reporterOutput;
    private String testRunId;
    private String testUuid;

    public MethodResult(String name, String status, String description, String duration, long startedAt, String isConfig, String testRunId, String parentTestName, String parentSuiteName, String testInstanceName) {
        super(name);
        this.status = status;
        this.description = description;
        this.testRunId = testRunId;
        this.testInstanceName = testInstanceName;
        this.parentTestName = parentTestName;
        this.parentSuiteName = parentSuiteName;
        this.startedAt = startedAt;
        try {
            long durationMs = Long.parseLong(duration);
            this.endedAt = startedAt + durationMs;
            this.duration = (float)durationMs / 1000.0f;
        }
        catch (NumberFormatException e) {
            System.err.println("Unable to parse duration value: " + duration);
        }
        if (isConfig != null) {
            this.isConfig = true;
        }
    }

    public void setTestUuid(String testUuid) {
        this.testUuid = testUuid;
    }

    public String getParentTestName() {
        return this.parentTestName;
    }

    public String getParentSuiteName() {
        return this.parentSuiteName;
    }

    public String getTestRunId() {
        return this.testRunId;
    }

    @Exported
    public Date getStartedAt() {
        return new Date(this.startedAt);
    }

    public long getStartTime() {
        return this.startedAt;
    }

    public long getEndTime() {
        return this.endedAt;
    }

    public MethodResultException getException() {
        return this.exception;
    }

    public void setException(MethodResultException exception) {
        this.exception = exception;
    }

    public String getSafeName() {
        Object name = this.getName();
        if (this.testUuid != null) {
            name = (String)name + "_" + this.testUuid;
        }
        return MethodResult.safe((String)name);
    }

    @Override
    public TestResult findCorrespondingResult(String id) {
        return this.getSafeName().equals(id) ? this : null;
    }

    @Exported
    public float getDuration() {
        return this.duration;
    }

    @Exported(visibility=9)
    public String getStatus() {
        return this.status;
    }

    @Exported
    public String getDescription() {
        return this.description;
    }

    @Exported
    public List<String> getGroups() {
        return this.groups;
    }

    @Exported
    public List<String> getParameters() {
        return this.parameters;
    }

    @Exported(name="exception")
    public String getErrorStackTrace() {
        if (this.exception != null) {
            return this.exception.toString();
        }
        return null;
    }

    public String getErrorDetails() {
        if (this.exception != null) {
            return this.exception.getMessage();
        }
        return null;
    }

    @Exported(name="className")
    public String getClassName() {
        return this.getParent().getName();
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public boolean isConfig() {
        return this.isConfig;
    }

    @POST
    public void doGraph(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        Graph g = this.getGraph(req, rsp);
        if (g != null) {
            g.doPng(req, rsp);
        }
    }

    @POST
    public void doGraphMap(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        Graph g = this.getGraph(req, rsp);
        if (g != null) {
            g.doMap(req, rsp);
        }
    }

    private Graph getGraph(final StaplerRequest2 req, StaplerResponse2 rsp) {
        Calendar t = this.getRun().getParent().getLastCompletedBuild().getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return null;
        }
        final DataSetBuilder dataSetBuilder = new DataSetBuilder();
        final HashMap<ChartUtil.NumberOnlyBuildLabel, String> statusMap = new HashMap<ChartUtil.NumberOnlyBuildLabel, String>();
        this.populateDataSetBuilder((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dataSetBuilder, statusMap);
        return new Graph(-1L, 800, 150){

            protected JFreeChart createGraph() {
                return GraphHelper.createMethodChart(req, dataSetBuilder.build(), statusMap, MethodResult.this.getUrl());
            }
        };
    }

    private void populateDataSetBuilder(DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> dataSetBuilder, Map<ChartUtil.NumberOnlyBuildLabel, String> statusMap) {
        Run build;
        int count = 0;
        for (build = this.getRun(); build != null; build = build.getNextBuild()) {
            this.addData(dataSetBuilder, statusMap, build);
        }
        for (build = this.getRun(); build != null && count++ < 10; build = build.getPreviousBuild()) {
            this.addData(dataSetBuilder, statusMap, build);
        }
    }

    private void addData(DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> dataSetBuilder, Map<ChartUtil.NumberOnlyBuildLabel, String> statusMap, Run<?, ?> build) {
        TestNGResult results;
        ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
        TestNGTestResultBuildAction action = (TestNGTestResultBuildAction)build.getAction(TestNGTestResultBuildAction.class);
        MethodResult methodResult = null;
        if (action != null && (results = action.getResult()) != null) {
            methodResult = this.getMethodResult(results);
        }
        if (methodResult == null) {
            dataSetBuilder.add((Number)0, (Comparable)((Object)"resultRow"), (Comparable)label);
            if (build.isBuilding()) {
                statusMap.put(label, "BUILD IN PROGRESS");
            } else {
                statusMap.put(label, "UNKNOWN");
            }
        } else {
            dataSetBuilder.add((Number)Float.valueOf(methodResult.getDuration()), (Comparable)((Object)"resultRow"), (Comparable)label);
            statusMap.put(label, methodResult.getStatus());
        }
    }

    private MethodResult getMethodResult(TestNGResult results) {
        Map<String, PackageResult> packageMap = results.getPackageMap();
        String methodPackageName = this.getParent().getParent().getName();
        String methodClassName = this.getParent().getName();
        if (packageMap.containsKey(methodPackageName) && packageMap.get(methodPackageName).getChildren() != null) {
            Collection classResults = packageMap.get(methodPackageName).getChildren();
            for (ClassResult classResult : classResults) {
                List<MethodResult> methodResults;
                if (!classResult.getName().equals(methodClassName) || (methodResults = this.isConfig ? classResult.getConfigurationMethods() : classResult.getTestMethods()) == null) continue;
                for (MethodResult methodResult : methodResults) {
                    if (!methodResult.getUrl().equals(this.getUrl())) continue;
                    return methodResult;
                }
            }
        }
        return null;
    }

    public Object getCssClass() {
        if (this.status != null) {
            if (this.status.equalsIgnoreCase("pass")) {
                return "result-passed";
            }
            if (this.status.equalsIgnoreCase("skip")) {
                return "result-skipped";
            }
            if (this.status.equalsIgnoreCase("fail")) {
                return "result-failed";
            }
        }
        return "result-passed";
    }

    public void setReporterOutput(String reporterOutput) {
        this.reporterOutput = reporterOutput;
    }

    public String getReporterOutput() {
        return this.reporterOutput;
    }

    public Collection<? extends TestResult> getChildren() {
        return null;
    }

    public boolean hasChildren() {
        return false;
    }
}

