/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.client;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class TestData {
    final String hash;

    private TestData(String hash) {
        this.hash = hash;
    }

    public static class Builder {
        private static final byte[] DIGEST_SEPARATOR = "-!#!-".getBytes();
        private MessageDigest digest = DigestUtils.getSha1Digest();

        public synchronized Builder addByteArray(byte[] content) {
            this.ensureHasNotBeenFinalized();
            DigestUtils.updateDigest((MessageDigest)this.digest, (byte[])content);
            DigestUtils.updateDigest((MessageDigest)this.digest, (byte[])DIGEST_SEPARATOR);
            return this;
        }

        private void ensureHasNotBeenFinalized() {
            if (this.digest == null) {
                throw new IllegalStateException("You tried to use this TestData.Builder after calling #build() on it. Builders cannot be reused.");
            }
        }

        public synchronized Builder addString(String content) {
            this.ensureHasNotBeenFinalized();
            DigestUtils.updateDigest((MessageDigest)this.digest, (String)content);
            DigestUtils.updateDigest((MessageDigest)this.digest, (byte[])DIGEST_SEPARATOR);
            return this;
        }

        public synchronized Builder addFileContent(Path fileWithContent) throws IOException {
            this.ensureHasNotBeenFinalized();
            DigestUtils.updateDigest((MessageDigest)this.digest, (Path)fileWithContent, (OpenOption[])new OpenOption[0]);
            DigestUtils.updateDigest((MessageDigest)this.digest, (byte[])DIGEST_SEPARATOR);
            return this;
        }

        public synchronized TestData build() {
            this.ensureHasNotBeenFinalized();
            String hash = Hex.encodeHexString((byte[])this.digest.digest());
            this.digest = null;
            return new TestData(hash);
        }
    }
}

