/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.client;

import com.teamscale.client.CommitDescriptor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import okhttp3.HttpUrl;

public class TeamscaleServer {
    public HttpUrl url;
    public String project;
    public String userName;
    public String userAccessToken;
    public String partition;
    public CommitDescriptor commit;
    public String revision;
    public String repository;
    public String configId;
    private String message = null;

    public String getMessage() {
        if (this.message == null) {
            return this.createDefaultMessage();
        }
        return this.message;
    }

    private String createDefaultMessage() {
        String hostnamePart = "uploaded from ";
        try {
            hostnamePart = hostnamePart + "hostname: " + InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostnamePart = hostnamePart + "an unknown computer";
        }
        String revisionPart = "";
        if (this.revision != null) {
            revisionPart = "\nfor revision: " + this.revision;
        }
        String configIdPart = "";
        if (this.configId != null) {
            configIdPart = "\nprofiler configuration ID: " + this.configId;
        }
        return this.partition + " coverage uploaded at " + DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()) + "\n\n" + hostnamePart + revisionPart + configIdPart;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isConfiguredForSingleProjectTeamscaleUpload() {
        return this.isConfiguredForServerConnection() && this.partition != null && this.project != null;
    }

    public boolean isConfiguredForMultiProjectUpload() {
        return this.isConfiguredForServerConnection() && this.partition != null && this.project == null;
    }

    public boolean isConfiguredForServerConnection() {
        return this.url != null && this.userName != null && this.userAccessToken != null;
    }

    public boolean canConnectToTeamscale() {
        return this.url != null && this.userName != null && this.userAccessToken != null;
    }

    public boolean hasAllFieldsNull() {
        return this.url == null && this.project == null && this.userName == null && this.userAccessToken == null && this.partition == null && this.commit == null && this.revision == null;
    }

    public boolean hasCommitOrRevision() {
        return this.commit != null || this.revision != null;
    }

    public String toString() {
        String at;
        if (this.revision != null) {
            at = "revision " + this.revision;
            if (this.repository != null) {
                at = at + "in repository " + this.repository;
            }
        } else {
            at = "commit " + this.commit;
        }
        return "Teamscale " + this.url + " as user " + this.userName + " for " + this.project + " to " + this.partition + " at " + at;
    }

    public TeamscaleServer withProjectAndCommit(String teamscaleProject, CommitDescriptor commitDescriptor) {
        TeamscaleServer teamscaleServer = new TeamscaleServer();
        teamscaleServer.url = this.url;
        teamscaleServer.userName = this.userName;
        teamscaleServer.userAccessToken = this.userAccessToken;
        teamscaleServer.partition = this.partition;
        teamscaleServer.project = teamscaleProject;
        teamscaleServer.commit = commitDescriptor;
        return teamscaleServer;
    }

    public TeamscaleServer withProjectAndRevision(String teamscaleProject, String revision) {
        TeamscaleServer teamscaleServer = new TeamscaleServer();
        teamscaleServer.url = this.url;
        teamscaleServer.userName = this.userName;
        teamscaleServer.userAccessToken = this.userAccessToken;
        teamscaleServer.partition = this.partition;
        teamscaleServer.project = teamscaleProject;
        teamscaleServer.revision = revision;
        return teamscaleServer;
    }
}

