/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.client;

import com.teamscale.client.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySystemProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxySystemProperties.class);
    private static final String PROXY_HOST_SYSTEM_PROPERTY = ".proxyHost";
    private static final String PROXY_PORT_SYSTEM_PROPERTY = ".proxyPort";
    private static final String PROXY_USER_SYSTEM_PROPERTY = ".proxyUser";
    private static final String PROXY_PASSWORD_SYSTEM_PROPERTY = ".proxyPassword";
    private final Protocol protocol;

    public ProxySystemProperties(Protocol protocol) {
        this.protocol = protocol;
    }

    public boolean proxyServerIsSet() {
        return !StringUtils.isEmpty(this.getProxyHost()) && this.getProxyPort() > 0;
    }

    public boolean proxyAuthIsSet() {
        return !StringUtils.isEmpty(this.getProxyUser()) && !StringUtils.isEmpty(this.getProxyPassword());
    }

    public String getProxyHost() {
        return System.getProperty(this.getProxyHostSystemPropertyName());
    }

    public int getProxyPort() {
        return this.parsePort(System.getProperty(this.getProxyPortSystemPropertyName()));
    }

    public void setProxyHost(String proxyHost) {
        System.setProperty(this.getProxyHostSystemPropertyName(), proxyHost);
    }

    @NotNull
    private String getProxyHostSystemPropertyName() {
        return (Object)((Object)this.protocol) + PROXY_HOST_SYSTEM_PROPERTY;
    }

    public void setProxyPort(int proxyPort) {
        this.setProxyPort(proxyPort + "");
    }

    public void setProxyPort(String proxyPort) {
        System.setProperty(this.getProxyPortSystemPropertyName(), proxyPort);
    }

    void removeProxyPort() {
        System.clearProperty(this.getProxyPortSystemPropertyName());
    }

    @NotNull
    private String getProxyPortSystemPropertyName() {
        return (Object)((Object)this.protocol) + PROXY_PORT_SYSTEM_PROPERTY;
    }

    public String getProxyUser() {
        return System.getProperty(this.getProxyUserSystemPropertyName());
    }

    public void setProxyUser(String proxyUser) {
        System.setProperty(this.getProxyUserSystemPropertyName(), proxyUser);
    }

    @NotNull
    private String getProxyUserSystemPropertyName() {
        return (Object)((Object)this.protocol) + PROXY_USER_SYSTEM_PROPERTY;
    }

    public String getProxyPassword() {
        return System.getProperty(this.getProxyPasswordSystemPropertyName());
    }

    public void setProxyPassword(String proxyPassword) {
        System.setProperty(this.getProxyPasswordSystemPropertyName(), proxyPassword);
    }

    @NotNull
    private String getProxyPasswordSystemPropertyName() {
        return (Object)((Object)this.protocol) + PROXY_PASSWORD_SYSTEM_PROPERTY;
    }

    private int parsePort(String portString) {
        if (portString == null) {
            return -1;
        }
        try {
            return Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Could not parse proxy port \"" + portString + "\" set via \"" + this.getProxyPortSystemPropertyName() + "\"");
            return -1;
        }
    }

    public static enum Protocol {
        HTTP,
        HTTPS;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

