/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class JsonUtils {
    public static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().visibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE)).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).serializationInclusion(JsonInclude.Include.NON_NULL)).build();

    public static JsonFactory createFactory() {
        return new JsonFactory((ObjectCodec)OBJECT_MAPPER);
    }

    public static <T> T deserialize(String json, Class<T> clazz) throws JsonProcessingException {
        return (T)OBJECT_MAPPER.readValue(json, clazz);
    }

    public static <T> T deserializeFile(File file, Class<T> clazz) throws IOException {
        return (T)OBJECT_MAPPER.readValue(file, clazz);
    }

    public static <T> List<T> deserializeList(String json, Class<T> elementClass) throws JsonProcessingException {
        return (List)OBJECT_MAPPER.readValue(json, (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionLikeType(List.class, elementClass));
    }

    public static String serialize(Object value) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString(value);
    }

    public static <T> void serializeToFile(File file, T value) throws IOException {
        OBJECT_MAPPER.writer().withDefaultPrettyPrinter().writeValue(file, value);
    }
}

