/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.client;

import com.teamscale.client.CommitDescriptor;
import com.teamscale.client.EReportFormat;
import com.teamscale.client.HttpUtils;
import com.teamscale.client.PrioritizableTest;
import com.teamscale.client.PrioritizableTestCluster;
import com.teamscale.client.ProcessInformation;
import com.teamscale.client.ProfilerInfo;
import com.teamscale.client.ProfilerRegistration;
import com.teamscale.client.TestWithClusterId;
import java.io.IOException;
import java.util.List;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface ITeamscaleService {
    @Multipart
    @POST(value="api/v5.9.0/projects/{projectAliasOrId}/external-analysis/session/auto-create/report")
    public Call<ResponseBody> uploadExternalReport(@Path(value="projectAliasOrId") String var1, @Query(value="format") String var2, @Query(value="t") CommitDescriptor var3, @Query(value="revision") String var4, @Query(value="repository") String var5, @Query(value="movetolastcommit") Boolean var6, @Query(value="partition") String var7, @Query(value="message") String var8, @Part(value="report") RequestBody var9);

    default public Call<ResponseBody> uploadExternalReport(String projectName, EReportFormat format, CommitDescriptor commit, String revision, String repository, Boolean moveToLastCommit, String partition, String message, RequestBody report) {
        return this.uploadExternalReport(projectName, format.name(), commit, revision, repository, moveToLastCommit, partition, message, report);
    }

    @Multipart
    @POST(value="api/v5.9.0/projects/{projectName}/external-analysis/session/auto-create/report")
    public Call<ResponseBody> uploadExternalReports(@Path(value="projectName") String var1, @Query(value="format") EReportFormat var2, @Query(value="t") CommitDescriptor var3, @Query(value="revision") String var4, @Query(value="repository") String var5, @Query(value="movetolastcommit") boolean var6, @Query(value="partition") String var7, @Query(value="message") String var8, @Part List<MultipartBody.Part> var9);

    @Multipart
    @POST(value="api/v5.9.0/projects/{projectName}/external-analysis/session/auto-create/report")
    public Call<ResponseBody> uploadExternalReports(@Path(value="projectName") String var1, @Query(value="format") String var2, @Query(value="t") CommitDescriptor var3, @Query(value="revision") String var4, @Query(value="repository") String var5, @Query(value="movetolastcommit") boolean var6, @Query(value="partition") String var7, @Query(value="message") String var8, @Part List<MultipartBody.Part> var9);

    @PUT(value="api/v9.4.0/projects/{projectName}/impacted-tests")
    public Call<List<PrioritizableTestCluster>> getImpactedTests(@Path(value="projectName") String var1, @Query(value="baseline") String var2, @Query(value="baseline-revision") String var3, @Query(value="end") CommitDescriptor var4, @Query(value="end-revision") String var5, @Query(value="repository") String var6, @Query(value="partitions") List<String> var7, @Query(value="include-non-impacted") boolean var8, @Query(value="include-failed-and-skipped") boolean var9, @Query(value="ensure-processed") boolean var10, @Query(value="include-added-tests") boolean var11, @Body List<TestWithClusterId> var12);

    @GET(value="api/v9.4.0/projects/{projectName}/impacted-tests")
    public Call<List<PrioritizableTest>> getImpactedTests(@Path(value="projectName") String var1, @Query(value="baseline") String var2, @Query(value="baseline-revision") String var3, @Query(value="end") CommitDescriptor var4, @Query(value="end-revision") String var5, @Query(value="repository") String var6, @Query(value="partitions") List<String> var7, @Query(value="include-non-impacted") boolean var8, @Query(value="include-failed-and-skipped") boolean var9, @Query(value="ensure-processed") boolean var10, @Query(value="include-added-tests") boolean var11);

    @POST(value="api/v9.4.0/running-profilers")
    public Call<ProfilerRegistration> registerProfiler(@Query(value="configuration-id") String var1, @Body ProcessInformation var2);

    @PUT(value="api/v9.4.0/running-profilers/{profilerId}")
    public Call<ResponseBody> sendHeartbeat(@Path(value="profilerId") String var1, @Body ProfilerInfo var2);

    @DELETE(value="api/v9.4.0/running-profilers/{profilerId}")
    public Call<ResponseBody> unregisterProfiler(@Path(value="profilerId") String var1);

    default public String uploadReport(String projectName, CommitDescriptor commit, String revision, String repository, String partition, EReportFormat reportFormat, String message, RequestBody report) throws IOException {
        Boolean moveToLastCommit = false;
        if (revision != null) {
            commit = null;
            moveToLastCommit = null;
        }
        try {
            Response response = this.uploadExternalReport(projectName, reportFormat, commit, revision, repository, moveToLastCommit, partition, message, report).execute();
            ResponseBody body = (ResponseBody)response.body();
            if (response.isSuccessful()) {
                if (body == null) {
                    return "";
                }
                return body.string();
            }
            String errorBody = HttpUtils.getErrorBodyStringSafe(response);
            throw new IOException("Request failed with error code " + response.code() + ". Response body: " + errorBody);
        }
        catch (IOException e) {
            throw new IOException("Failed to upload report. " + e.getMessage(), e);
        }
    }
}

