/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.client;

import com.teamscale.client.ProxySystemProperties;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Base64;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;
import retrofit2.Retrofit;

public class HttpUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtils.class);
    public static final Duration DEFAULT_READ_TIMEOUT = Duration.ofSeconds(60L);
    public static final Duration DEFAULT_WRITE_TIMEOUT = Duration.ofSeconds(60L);
    public static final String PROXY_AUTHORIZATION_HTTP_HEADER = "Proxy-Authorization";
    private static boolean shouldValidateSsl = true;

    public static void setShouldValidateSsl(boolean shouldValidateSsl) {
        HttpUtils.shouldValidateSsl = shouldValidateSsl;
    }

    public static Retrofit createRetrofit(Consumer<Retrofit.Builder> retrofitBuilderAction, Consumer<OkHttpClient.Builder> okHttpBuilderAction) {
        return HttpUtils.createRetrofit(retrofitBuilderAction, okHttpBuilderAction, DEFAULT_READ_TIMEOUT, DEFAULT_WRITE_TIMEOUT);
    }

    public static Retrofit createRetrofit(Consumer<Retrofit.Builder> retrofitBuilderAction, Consumer<OkHttpClient.Builder> okHttpBuilderAction, Duration readTimeout, Duration writeTimeout) {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        HttpUtils.setTimeouts(httpClientBuilder, readTimeout, writeTimeout);
        HttpUtils.setUpSslValidation(httpClientBuilder);
        HttpUtils.setUpProxyServer(httpClientBuilder);
        okHttpBuilderAction.accept(httpClientBuilder);
        Retrofit.Builder builder = new Retrofit.Builder().client(httpClientBuilder.build());
        retrofitBuilderAction.accept(builder);
        return builder.build();
    }

    private static void setUpProxyServer(OkHttpClient.Builder httpClientBuilder) {
        boolean setHttpsProxyWasSuccessful = HttpUtils.setUpProxyServerForProtocol(ProxySystemProperties.Protocol.HTTPS, httpClientBuilder);
        if (!setHttpsProxyWasSuccessful) {
            HttpUtils.setUpProxyServerForProtocol(ProxySystemProperties.Protocol.HTTP, httpClientBuilder);
        }
    }

    private static boolean setUpProxyServerForProtocol(ProxySystemProperties.Protocol protocol, OkHttpClient.Builder httpClientBuilder) {
        ProxySystemProperties proxySystemProperties = new ProxySystemProperties(protocol);
        String proxyHost = proxySystemProperties.getProxyHost();
        int proxyPort = proxySystemProperties.getProxyPort();
        String proxyUser = proxySystemProperties.getProxyUser();
        String proxyPassword = proxySystemProperties.getProxyPassword();
        if (proxySystemProperties.proxyServerIsSet()) {
            HttpUtils.useProxyServer(httpClientBuilder, proxyHost, proxyPort);
            if (proxySystemProperties.proxyAuthIsSet()) {
                HttpUtils.useProxyAuthenticator(httpClientBuilder, proxyUser, proxyPassword);
            }
            return true;
        }
        return false;
    }

    private static void useProxyServer(OkHttpClient.Builder httpClientBuilder, String proxyHost, int proxyPort) {
        httpClientBuilder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)));
    }

    private static void useProxyAuthenticator(OkHttpClient.Builder httpClientBuilder, String user, String password) {
        Authenticator proxyAuthenticator = (route, response) -> {
            String credential = Credentials.basic((String)user, (String)password);
            return response.request().newBuilder().header(PROXY_AUTHORIZATION_HTTP_HEADER, credential).build();
        };
        httpClientBuilder.proxyAuthenticator(proxyAuthenticator);
    }

    private static void setTimeouts(OkHttpClient.Builder builder, Duration readTimeout, Duration writeTimeout) {
        builder.connectTimeout(Duration.ofSeconds(60L));
        builder.readTimeout(readTimeout);
        builder.writeTimeout(writeTimeout);
    }

    private static void setUpSslValidation(OkHttpClient.Builder builder) {
        SSLSocketFactory sslSocketFactory;
        if (shouldValidateSsl) {
            return;
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{TrustAllCertificatesManager.INSTANCE}, new SecureRandom());
            sslSocketFactory = sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Could not disable SSL certificate validation. Leaving it enabled", (Throwable)e);
            return;
        }
        builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)TrustAllCertificatesManager.INSTANCE);
        builder.hostnameVerifier((hostName, session) -> true);
    }

    public static <T> String getErrorBodyStringSafe(Response<T> response) throws IOException {
        ResponseBody errorBody = response.errorBody();
        if (errorBody == null) {
            return "<no response body provided>";
        }
        return errorBody.string();
    }

    public static Interceptor getBasicAuthInterceptor(String username, String password) {
        String credentials = username + ":" + password;
        String basic = "Basic " + Base64.getEncoder().encodeToString(credentials.getBytes());
        return chain -> {
            Request newRequest = chain.request().newBuilder().header("Authorization", basic).build();
            return chain.proceed(newRequest);
        };
    }

    public static class TrustAllCertificatesManager
    implements X509TrustManager {
        static final TrustAllCertificatesManager INSTANCE = new TrustAllCertificatesManager();

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

