/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.client;

import com.teamscale.client.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FileSystemUtils {
    public static final String UTF8_ENCODING = StandardCharsets.UTF_8.name();
    private static final char UNIX_SEPARATOR = '/';

    public static void ensureDirectoryExists(File directory) throws IOException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Couldn't create directory: " + directory);
        }
    }

    public static List<File> listFilesRecursively(File directory, FileFilter filter) {
        if (directory == null || !directory.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<File> result = new ArrayList<File>();
        FileSystemUtils.listFilesRecursively(directory, result, filter);
        return result;
    }

    public static String getFileExtension(File file) {
        String name = file.getName();
        int posLastDot = name.lastIndexOf(46);
        if (posLastDot < 0) {
            return null;
        }
        return name.substring(posLastDot + 1);
    }

    private static void listFilesRecursively(File directory, Collection<File> result, FileFilter filter) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                FileSystemUtils.listFilesRecursively(file, result, filter);
            }
            if (filter != null && !filter.accept(file)) continue;
            result.add(file);
        }
    }

    public static String normalizeSeparators(String path) {
        return path.replace(File.separatorChar, '/');
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        int size = 0;
        while ((len = input.read(buffer)) > 0) {
            output.write(buffer, 0, len);
            size += len;
        }
        return size;
    }

    public static String getFilenameWithoutExtension(File file) {
        return FileSystemUtils.getFilenameWithoutExtension(file.getName());
    }

    public static String getFilenameWithoutExtension(String fileName) {
        return StringUtils.removeLastPart(fileName, '.');
    }
}

