/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner;

import com.sysdig.jenkins.plugins.sysdig.domain.SysdigLogger;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner.LogOutputStreamAdapter;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class SysdigProcessBuilderBase<T extends SysdigProcessBuilderBase<T>>
implements Cloneable {
    protected final String sysdigCLIPath;
    protected String engineURL;
    protected String scanResultOutputPath;
    protected boolean consoleLogEnabled;
    protected LogLevel logLevel;
    protected boolean verifyTLS;
    protected List<String> extraParams;
    protected List<String> policiesToApply;
    protected FilePath workingDirectory;
    protected EnvVars extraEnvVars;
    protected OutputStream redirectedStdoutStream;
    protected OutputStream redirectedStdErrStream;

    public SysdigProcessBuilderBase(String sysdigCLIPath, String sysdigAPIToken) {
        this.sysdigCLIPath = sysdigCLIPath;
        this.engineURL = "https://secure.sysdig.com";
        this.scanResultOutputPath = "";
        this.consoleLogEnabled = false;
        this.logLevel = LogLevel.INFO;
        this.verifyTLS = true;
        this.extraParams = new ArrayList<String>();
        this.policiesToApply = new ArrayList<String>();
        this.workingDirectory = null;
        this.extraEnvVars = new EnvVars();
        this.extraEnvVars.put("SECURE_API_TOKEN", sysdigAPIToken);
    }

    public T withEngineURL(String engineURL) {
        Object clone = this.clone();
        ((SysdigProcessBuilderBase)clone).engineURL = engineURL;
        return (T)clone;
    }

    public T withScanResultOutputPath(String scanResultOutputPath) {
        Object clone = this.clone();
        ((SysdigProcessBuilderBase)clone).scanResultOutputPath = scanResultOutputPath;
        return (T)clone;
    }

    public T withConsoleLog() {
        Object clone = this.clone();
        ((SysdigProcessBuilderBase)clone).consoleLogEnabled = true;
        return (T)clone;
    }

    public T withLogLevel(LogLevel logLevel) {
        Object clone = this.clone();
        ((SysdigProcessBuilderBase)clone).logLevel = logLevel;
        return (T)clone;
    }

    public T withTLSVerification(boolean verifyTLS) {
        Object clone = this.clone();
        ((SysdigProcessBuilderBase)clone).verifyTLS = verifyTLS;
        return (T)clone;
    }

    public T withExtraParametersSeparatedBySpace(String inlineScanExtraParams) {
        Object clone = this.clone();
        Arrays.stream(inlineScanExtraParams.split(" ")).map(String::trim).filter(param -> !param.isEmpty()).forEach(((SysdigProcessBuilderBase)clone).extraParams::add);
        return (T)clone;
    }

    public T withPoliciesToApplySeparatedBySpace(String policiesToApply) {
        Object clone = this.clone();
        Arrays.stream(policiesToApply.split(" ")).map(String::trim).filter(policy -> !policy.isEmpty()).forEach(((SysdigProcessBuilderBase)clone).policiesToApply::add);
        return (T)clone;
    }

    public T withWorkingDirectory(FilePath workingDirectory) {
        Object clone = this.clone();
        ((SysdigProcessBuilderBase)clone).workingDirectory = workingDirectory;
        return (T)clone;
    }

    public T withExtraEnvVars(EnvVars envVars) {
        Object clone = this.clone();
        ((SysdigProcessBuilderBase)clone).extraEnvVars.putAll((Map)envVars);
        return (T)clone;
    }

    public T withStdoutRedirectedTo(OutputStream outputStream) {
        Object clone = this.clone();
        ((SysdigProcessBuilderBase)clone).redirectedStdoutStream = outputStream;
        return (T)clone;
    }

    public T withStderrRedirectedTo(OutputStream outputStream) {
        Object clone = this.clone();
        ((SysdigProcessBuilderBase)clone).redirectedStdErrStream = outputStream;
        return (T)clone;
    }

    public T withStdoutRedirectedTo(SysdigLogger sysdigLogger) {
        return this.withStdoutRedirectedTo(new LogOutputStreamAdapter(sysdigLogger));
    }

    public T withStderrRedirectedTo(SysdigLogger sysdigLogger) {
        return this.withStderrRedirectedTo(new LogOutputStreamAdapter(sysdigLogger));
    }

    public int launchAndWait(@NonNull Launcher launcher) throws IOException, InterruptedException {
        Launcher.ProcStarter procStarter = launcher.launch().cmds(this.toCommandLineArguments()).envs((Map)this.extraEnvVars);
        if (this.workingDirectory != null) {
            procStarter.pwd(this.workingDirectory);
        }
        if (this.redirectedStdoutStream != null) {
            procStarter.stdout(this.redirectedStdoutStream);
        }
        if (this.redirectedStdErrStream != null) {
            procStarter.stderr(this.redirectedStdErrStream);
        }
        return procStarter.join();
    }

    public abstract List<String> toCommandLineArguments();

    public T clone() {
        try {
            SysdigProcessBuilderBase cloned = (SysdigProcessBuilderBase)super.clone();
            cloned.extraParams = new ArrayList<String>(this.extraParams);
            cloned.policiesToApply = new ArrayList<String>(this.policiesToApply);
            cloned.extraEnvVars = new EnvVars(this.extraEnvVars);
            return (T)cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError("Clone not supported", e);
        }
    }

    public static enum LogLevel {
        DEBUG,
        INFO;


        public String toString() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case INFO -> "info";
                case DEBUG -> "debug";
            };
        }
    }
}

