/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult;

import com.sysdig.jenkins.plugins.sysdig.domain.AggregateChild;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Architecture;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.OperatingSystem;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.ScanResult;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Metadata
implements AggregateChild<ScanResult>,
Serializable {
    private final String pullString;
    private final String imageID;
    private final String digest;
    private final OperatingSystem baseOS;
    private final BigInteger sizeInBytes;
    private final Architecture architecture;
    private final Map<String, String> labels;
    private final Date createdAt;
    private final ScanResult root;

    Metadata(String pullString, String imageID, String digest, OperatingSystem baseOS, BigInteger sizeInBytes, Architecture architecture, Map<String, String> labels, Date createdAt, ScanResult root) {
        this.pullString = pullString;
        this.imageID = imageID;
        this.digest = digest;
        this.baseOS = baseOS;
        this.sizeInBytes = sizeInBytes;
        this.architecture = architecture;
        this.labels = labels;
        this.createdAt = createdAt;
        this.root = root;
    }

    public String pullString() {
        return this.pullString;
    }

    public String imageID() {
        return this.imageID;
    }

    public Optional<String> digest() {
        if (this.digest == null || this.digest.isBlank()) {
            return Optional.empty();
        }
        return Optional.of(this.digest);
    }

    public OperatingSystem baseOS() {
        return this.baseOS;
    }

    public BigInteger sizeInBytes() {
        return this.sizeInBytes;
    }

    public Architecture architecture() {
        return this.architecture;
    }

    public Map<String, String> labels() {
        return this.labels;
    }

    public Date createdAt() {
        return this.createdAt;
    }

    @Override
    public ScanResult root() {
        return this.root;
    }

    long layersCount() {
        return this.root().layers().stream().filter(l -> l.size().isPresent()).count();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        return Objects.equals(this.pullString, metadata.pullString) && Objects.equals(this.imageID, metadata.imageID) && Objects.equals(this.digest, metadata.digest) && Objects.equals(this.baseOS, metadata.baseOS) && Objects.equals(this.sizeInBytes, metadata.sizeInBytes) && this.architecture == metadata.architecture && Objects.equals(this.labels, metadata.labels) && Objects.equals(this.createdAt, metadata.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.pullString, this.imageID, this.digest, this.baseOS, this.sizeInBytes, this.architecture, this.labels, this.createdAt);
    }
}

