/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.infrastructure.http;

import com.sysdig.jenkins.plugins.sysdig.domain.SysdigLogger;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins.RunContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class RemoteDownloader {
    private final RunContext runContext;
    protected final SysdigLogger logger;
    private final EnvVars envVars;

    public RemoteDownloader(@NonNull RunContext runContext) {
        this.runContext = runContext;
        this.logger = runContext.getLogger();
        this.envVars = runContext.getEnvVars();
    }

    public FilePath downloadExecutable(URL url, String fileName) throws IOException, InterruptedException {
        FilePath executableFile = this.downloadFile(url, fileName);
        executableFile.chmod(493);
        this.logger.logInfo("Permissions set: " + executableFile.getRemote());
        return executableFile;
    }

    public FilePath downloadFile(URL url, String fileName) throws IOException, InterruptedException {
        boolean hostMustBeProxied;
        FilePath binFolder = this.runContext.getPathFromWorkspace(new String[0]).child("bin");
        binFolder.mkdirs();
        FilePath outputFile = binFolder.child(fileName);
        Proxy proxy = RemoteDownloader.getHttpProxyFromEnvVars(this.envVars);
        this.logger.logInfo(String.format("Downloading %s to %s", url, fileName));
        boolean bl = hostMustBeProxied = proxy != Proxy.NO_PROXY && !this.isThereAProxyExceptionForHost(url.getHost());
        if (hostMustBeProxied) {
            this.logger.logInfo("Downloading with proxy: " + String.valueOf(proxy.address()));
            URLConnection connection = url.openConnection(proxy);
            outputFile.copyFrom(connection.getInputStream());
        } else {
            this.logger.logInfo("Downloading without proxy");
            outputFile.copyFrom(url);
        }
        return outputFile;
    }

    private static Stream<String> getURLsThatMustNotBeProxiedFromEnvVars(@NonNull EnvVars envVars) {
        Stream envVarStream = envVars.entrySet().stream();
        Optional<Map.Entry> firstNoProxyEnvVar = envVarStream.filter(entry -> ((String)entry.getKey()).equalsIgnoreCase("no_proxy")).findFirst();
        Optional<String> firstNoProxyEnvVarValue = firstNoProxyEnvVar.map(Map.Entry::getValue);
        Stream<String> allURLsInNoProxy = firstNoProxyEnvVarValue.stream().flatMap(value -> Arrays.stream(value.split(",")));
        Stream<String> allURLsTrimmed = allURLsInNoProxy.map(String::trim);
        return allURLsTrimmed;
    }

    private static Proxy getHttpProxyFromEnvVars(@NonNull EnvVars envVars) throws MalformedURLException {
        URL proxyURL;
        Optional<String> possibleProxyAddress = envVars.entrySet().stream().filter(ks -> ((String)ks.getKey()).equalsIgnoreCase("https_proxy") || ((String)ks.getKey()).equalsIgnoreCase("http_proxy")).findFirst().map(Map.Entry::getValue);
        if (possibleProxyAddress.isEmpty()) {
            return Proxy.NO_PROXY;
        }
        Object proxyAddress = possibleProxyAddress.get();
        if (!((String)proxyAddress).startsWith("http://") && !((String)proxyAddress).startsWith("https://")) {
            proxyAddress = "http://" + (String)proxyAddress;
        }
        int port = (proxyURL = new URL((String)proxyAddress)).getPort() != -1 ? proxyURL.getPort() : 80;
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyURL.getHost(), port));
    }

    private boolean isThereAProxyExceptionForHost(String host) {
        return RemoteDownloader.getURLsThatMustNotBeProxiedFromEnvVars(this.envVars).anyMatch(host::contains);
    }
}

