/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins.vm.ui;

import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.ScanResult;
import hudson.model.Action;
import hudson.model.Run;
import java.util.Map;
import jenkins.model.Jenkins;

public class SysdigAction
implements Action {
    private final Run<?, ?> build;
    private final String gateStatus;
    private final String gateOutputUrl;
    private final String cveListingUrl;
    @Deprecated
    private String gateReportUrl;
    @Deprecated
    private Map<String, String> queries;
    private final String imageTag;
    private final String imageDigest;

    public SysdigAction(Run<?, ?> run, ScanResult scanResult, String jenkinsOutputDirName, String policyReportFilename, String cveListingFileName) {
        this.build = run;
        this.gateStatus = scanResult.evaluationResult().toString();
        this.imageTag = scanResult.metadata().pullString();
        this.imageDigest = scanResult.metadata().imageID().replace(':', '-');
        this.gateOutputUrl = String.format("../artifact/%s/%s", jenkinsOutputDirName, policyReportFilename);
        this.cveListingUrl = String.format("../artifact/%s/%s", jenkinsOutputDirName, cveListingFileName);
    }

    public String getIconFileName() {
        return Jenkins.RESOURCE_PATH + "/plugin/sysdig-secure/images/sysdig-shovel.png";
    }

    public String getDisplayName() {
        return String.format("Sysdig Secure Report (%s) (%s)", this.imageTag, this.gateStatus);
    }

    public String getUrlName() {
        return String.format("sysdig-secure-results-%s", this.imageDigest);
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public String getGateStatus() {
        return this.gateStatus;
    }

    public String getGateOutputUrl() {
        return this.gateOutputUrl;
    }

    public String getCveListingUrl() {
        return this.cveListingUrl;
    }

    public String getGateReportUrl() {
        return this.gateReportUrl;
    }

    public Map<String, String> getQueries() {
        return this.queries;
    }
}

