/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins.vm.entrypoint;

import com.google.common.collect.ImmutableSet;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins.vm.entrypoint.ImageScanningBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepMonitor;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ImageScanningStep
extends Step
implements BuildStep {
    final ImageScanningBuilder builder;

    @DataBoundConstructor
    public ImageScanningStep(String imageName) {
        this.builder = new ImageScanningBuilder(imageName);
    }

    public String getImageName() {
        return this.builder.getImageName();
    }

    public boolean getBailOnFail() {
        return this.builder.getBailOnFail();
    }

    @DataBoundSetter
    public void setBailOnFail(boolean bailOnFail) {
        this.builder.setBailOnFail(bailOnFail);
    }

    public boolean getBailOnPluginFail() {
        return this.builder.getBailOnPluginFail();
    }

    @DataBoundSetter
    public void setBailOnPluginFail(boolean bailOnPluginFail) {
        this.builder.setBailOnPluginFail(bailOnPluginFail);
    }

    public String getPoliciesToApply() {
        return this.builder.getPoliciesToApply();
    }

    @DataBoundSetter
    public void setPoliciesToApply(String policiesToApply) {
        this.builder.setPoliciesToApply(policiesToApply);
    }

    public String getCliVersionToApply() {
        return this.builder.getCliVersionToApply();
    }

    @DataBoundSetter
    public void setCliVersionToApply(String cliVersionToApply) {
        this.builder.setCliVersionToApply(cliVersionToApply);
    }

    public String getCustomCliVersion() {
        return this.builder.getCustomCliVersion();
    }

    @DataBoundSetter
    public void setCustomCliVersion(String customCliVersion) {
        this.builder.setCustomCliVersion(customCliVersion);
    }

    public String getEngineURL() {
        return this.builder.getEngineURL();
    }

    @DataBoundSetter
    public void setEngineURL(String engineurl) {
        this.builder.setEngineURL(engineurl);
    }

    public String getEngineCredentialsId() {
        return this.builder.getEngineCredentialsId();
    }

    @DataBoundSetter
    public void setEngineCredentialsId(String engineCredentialsId) {
        this.builder.setEngineCredentialsId(engineCredentialsId);
    }

    public boolean getEngineVerify() {
        return this.builder.getEngineVerify();
    }

    @DataBoundSetter
    public void setEngineVerify(boolean engineVerify) {
        this.builder.setEngineVerify(engineVerify);
    }

    public String getInlineScanExtraParams() {
        return this.builder.getInlineScanExtraParams();
    }

    @DataBoundSetter
    public void setInlineScanExtraParams(String inlineScanExtraParams) {
        this.builder.setInlineScanExtraParams(inlineScanExtraParams);
    }

    public String getScannerBinaryPath() {
        return this.builder.getScannerBinaryPath();
    }

    @DataBoundSetter
    public void setScannerBinaryPath(String scannerBinayPath) {
        this.builder.setScannerBinaryPath(scannerBinayPath);
    }

    public StepExecution start(StepContext stepContext) {
        return new Execution(stepContext, this.builder);
    }

    public boolean prebuild(AbstractBuild<?, ?> abstractBuild, BuildListener buildListener) {
        return this.builder.prebuild(abstractBuild, buildListener);
    }

    public boolean perform(AbstractBuild<?, ?> abstractBuild, Launcher launcher, BuildListener buildListener) throws InterruptedException, IOException {
        return this.builder.perform(abstractBuild, launcher, buildListener);
    }

    @Deprecated
    public Action getProjectAction(AbstractProject<?, ?> abstractProject) {
        return this.builder.getProjectAction(abstractProject);
    }

    @NonNull
    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> abstractProject) {
        return this.builder.getProjectActions(abstractProject);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return this.builder.getRequiredMonitorService();
    }

    private static final class Execution
    extends SynchronousNonBlockingStepExecution {
        private static final long serialVersionUID = 1L;
        private final transient ImageScanningBuilder builder;

        private Execution(@NonNull StepContext context, ImageScanningBuilder builder) {
            super(context);
            this.builder = builder;
        }

        protected Void run() throws Exception {
            FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
            assert (workspace != null);
            workspace.mkdirs();
            this.builder.perform((Run)this.getContext().get(Run.class), workspace, (EnvVars)this.getContext().get(EnvVars.class), (Launcher)this.getContext().get(Launcher.class), (TaskListener)this.getContext().get(TaskListener.class));
            return null;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public static final boolean DEFAULT_BAIL_ON_FAIL = true;
        public static final boolean DEFAULT_BAIL_ON_PLUGIN_FAIL = true;
        public static final String DEFAULT_ENGINE_URL = "https://secure.sysdig.com";
        public static final boolean DEFAULT_ENGINE_VERIFY = true;
        ImageScanningBuilder.GlobalConfiguration builderDescriptor = new ImageScanningBuilder.GlobalConfiguration();

        public DescriptorImpl() {
            this.builderDescriptor.load();
        }

        @NonNull
        public String getDisplayName() {
            return "Sysdig Image Scanning pipeline step";
        }

        public ListBoxModel doFillEngineCredentialsIdItems(@QueryParameter String credentialsId) {
            return this.builderDescriptor.doFillEngineCredentialsIdItems(credentialsId);
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(FilePath.class, Run.class, Launcher.class, TaskListener.class, EnvVars.class);
        }

        public String getFunctionName() {
            return "sysdigImageScan";
        }
    }
}

