/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins.vm;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.sysdig.jenkins.plugins.sysdig.application.vm.ReportStorage;
import com.sysdig.jenkins.plugins.sysdig.application.vm.report.PolicyEvaluationReport;
import com.sysdig.jenkins.plugins.sysdig.application.vm.report.VulnerabilityReportProcessor;
import com.sysdig.jenkins.plugins.sysdig.domain.SysdigLogger;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.ScanResult;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins.RunContext;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins.vm.ui.SysdigAction;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.json.GsonBuilder;
import hudson.AbortException;
import hudson.FilePath;
import hudson.model.Action;
import hudson.tasks.ArtifactArchiver;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import jenkins.tasks.SimpleBuildStep;

public class JenkinsReportStorage
implements ReportStorage,
AutoCloseable {
    private static final String JENKINS_DIR_NAME_PREFIX = "SysdigSecureReport_";
    private static final String CVE_LISTING_FILENAME_FORMAT = "sysdig_secure_security-%s.json";
    private static final String POLICY_REPORT_FILENAME_FORMAT = "sysdig_secure_gates-%s.json";
    private static final String RAW_VULN_REPORT_FILENAME_FORMAT = "sysdig_secure_raw_vulns_report-%s.json";
    private final RunContext runContext;
    private final SysdigLogger logger;
    private final String jenkinsOutputDirName;

    public JenkinsReportStorage(RunContext runContext) {
        this.runContext = runContext;
        this.logger = runContext.getLogger();
        this.jenkinsOutputDirName = JENKINS_DIR_NAME_PREFIX + runContext.getJobNumber();
        this.initializeJenkinsWorkspace();
    }

    private void initializeJenkinsWorkspace() {
        try {
            this.logger.logDebug("Initializing Jenkins workspace");
            FilePath jenkinsReportDir = this.runContext.getPathFromWorkspace(this.jenkinsOutputDirName);
            if (!jenkinsReportDir.exists()) {
                this.logger.logDebug(String.format("Creating workspace directory %s", this.jenkinsOutputDirName));
                jenkinsReportDir.mkdirs();
            }
        }
        catch (IOException | InterruptedException e) {
            this.logger.logWarn("Failed to initialize Jenkins workspace", e);
        }
    }

    @Override
    public void savePolicyReport(ScanResult scanResult, PolicyEvaluationReport report) throws IOException, InterruptedException {
        FilePath outPath = this.runContext.getPathFromWorkspace(this.jenkinsOutputDirName, String.format(POLICY_REPORT_FILENAME_FORMAT, scanResult.metadata().imageID()));
        this.logger.logDebug(String.format("Writing policy evaluation result to %s", outPath.getRemote()));
        outPath.write(GsonBuilder.build().toJson((Object)report), String.valueOf(StandardCharsets.UTF_8));
    }

    @Override
    public void saveVulnerabilityReport(ScanResult scanResult) throws IOException, InterruptedException {
        FilePath outPath = this.runContext.getPathFromWorkspace(this.jenkinsOutputDirName, String.format(CVE_LISTING_FILENAME_FORMAT, scanResult.metadata().imageID()));
        JsonObject securityJson = VulnerabilityReportProcessor.generateVulnerabilityReport(scanResult);
        this.logger.logDebug(String.format("Writing vulnerability report to %s", outPath.getRemote()));
        outPath.write(securityJson.toString(), String.valueOf(StandardCharsets.UTF_8));
    }

    @Override
    public void saveRawVulnerabilityReport(ScanResult scanResult) throws IOException, InterruptedException {
        String outFilename = String.format(RAW_VULN_REPORT_FILENAME_FORMAT, scanResult.metadata().imageID());
        FilePath outPath = this.runContext.getPathFromWorkspace(this.jenkinsOutputDirName, outFilename);
        this.logger.logDebug(String.format("Writing raw vulnerability report to %s", outPath.getRemote()));
    }

    @Override
    public void archiveResults(ScanResult scanResult) throws IOException {
        try {
            this.logger.logDebug("Archiving results");
            this.runContext.perform((SimpleBuildStep)new ArtifactArchiver(this.jenkinsOutputDirName + "/"));
            this.logger.logDebug("Setting up build results in the UI");
            String policyReportFilename = String.format(POLICY_REPORT_FILENAME_FORMAT, scanResult.metadata().imageID());
            String cveListingFileName = String.format(CVE_LISTING_FILENAME_FORMAT, scanResult.metadata().imageID());
            this.runContext.getRun().addAction((Action)new SysdigAction(this.runContext.getRun(), scanResult, this.jenkinsOutputDirName, policyReportFilename, cveListingFileName));
        }
        catch (Exception e) {
            this.logger.logError("Failed to setup build results due to an unexpected error", e);
            throw new AbortException("Failed to setup build results due to an unexpected error. Please refer to above logs for more information");
        }
    }

    @Override
    public void close() {
        this.logger.logDebug("Cleaning up build artifacts");
        if (!Strings.isNullOrEmpty((String)this.jenkinsOutputDirName)) {
            this.logger.logDebug("Deleting Jenkins workspace " + this.jenkinsOutputDirName);
            this.cleanJenkinsWorkspaceQuietly();
        }
    }

    private void cleanJenkinsWorkspaceQuietly() {
        FilePath jenkinsOutputDirFP = this.runContext.getPathFromWorkspace(this.jenkinsOutputDirName);
        try {
            jenkinsOutputDirFP.deleteRecursive();
        }
        catch (IOException | InterruptedException e) {
            this.logger.logDebug("Unable to delete Jenkins workspace " + this.jenkinsOutputDirName, e);
        }
    }
}

