/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins.vm;

import com.google.common.base.Strings;
import com.sysdig.jenkins.plugins.sysdig.application.vm.ImageScanningConfig;
import com.sysdig.jenkins.plugins.sysdig.domain.SysdigLogger;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins.RunContext;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.jenkins.vm.entrypoint.ImageScanningBuilder;
import hudson.AbortException;
import hudson.PluginWrapper;
import java.io.Serializable;
import java.util.List;
import jenkins.model.Jenkins;

public class ImageImageScanningConfig
implements Serializable,
ImageScanningConfig {
    private final String imageName;
    private final boolean bailOnFail;
    private final boolean bailOnPluginFail;
    private final String engineurl;
    private final boolean engineverify;
    private final String inlineScanExtraParams;
    private final String sysdigToken;
    private final String policiesToApply;
    private final String scannerBinaryPath;
    private final String cliVersionToApply;
    private final String customCliVersion;

    public ImageImageScanningConfig(RunContext runContext, ImageScanningBuilder engineBuilder) throws AbortException {
        ImageScanningBuilder.GlobalConfiguration globalConfig = engineBuilder.getDescriptor();
        String credID = this.firstNonEmpty(engineBuilder.getEngineCredentialsId(), globalConfig.getEngineCredentialsId());
        this.sysdigToken = runContext.getSysdigTokenFromCredentials(credID);
        this.imageName = engineBuilder.getImageName();
        this.bailOnFail = engineBuilder.getBailOnFail();
        this.bailOnPluginFail = engineBuilder.getBailOnPluginFail();
        if (!Strings.isNullOrEmpty((String)engineBuilder.getEngineURL())) {
            this.engineurl = engineBuilder.getEngineURL();
            this.engineverify = engineBuilder.getEngineVerify();
        } else {
            this.engineurl = globalConfig.getEngineURL();
            this.engineverify = globalConfig.getEngineVerify();
        }
        this.inlineScanExtraParams = this.firstNonEmpty(engineBuilder.getInlineScanExtraParams(), globalConfig.getInlineScanExtraParams());
        this.policiesToApply = this.firstNonEmpty(engineBuilder.getPoliciesToApply(), globalConfig.getPoliciesToApply());
        this.cliVersionToApply = !Strings.isNullOrEmpty((String)engineBuilder.getCliVersionToApply()) ? engineBuilder.getCliVersionToApply() : globalConfig.getCliVersionToApply();
        this.customCliVersion = !Strings.isNullOrEmpty((String)engineBuilder.getCustomCliVersion()) ? engineBuilder.getCustomCliVersion() : globalConfig.getCustomCliVersion();
        this.scannerBinaryPath = !Strings.isNullOrEmpty((String)engineBuilder.getScannerBinaryPath()) ? engineBuilder.getScannerBinaryPath() : globalConfig.getScannerBinaryPath();
    }

    private String firstNonEmpty(String ... strings) {
        for (String s : strings) {
            if (Strings.isNullOrEmpty((String)s)) continue;
            return s;
        }
        return "";
    }

    @Override
    public String getImageName() {
        return this.imageName;
    }

    @Override
    public boolean getBailOnFail() {
        return this.bailOnFail;
    }

    @Override
    public boolean getBailOnPluginFail() {
        return this.bailOnPluginFail;
    }

    @Override
    public String getEngineurl() {
        return this.engineurl;
    }

    @Override
    public String getSysdigToken() {
        return this.sysdigToken;
    }

    @Override
    public boolean getEngineverify() {
        return this.engineverify;
    }

    @Override
    public String getInlineScanExtraParams() {
        return this.inlineScanExtraParams;
    }

    @Override
    public String getPoliciesToApply() {
        return this.policiesToApply;
    }

    @Override
    public String getCliVersionToApply() {
        return this.cliVersionToApply;
    }

    @Override
    public String getCustomCliVersion() {
        return this.customCliVersion;
    }

    @Override
    public String getScannerBinaryPath() {
        return this.scannerBinaryPath;
    }

    @Override
    public void printWith(SysdigLogger logger) {
        logger.logInfo("Jenkins version: " + Jenkins.VERSION);
        List plugins = Jenkins.get().getPluginManager().getPlugins();
        if (plugins != null) {
            for (PluginWrapper plugin : plugins) {
                if (!plugin.getShortName().equals("sysdig-secure")) continue;
                logger.logInfo(String.format("%s version: %s", plugin.getDisplayName(), plugin.getVersion()));
                break;
            }
        }
        logger.logInfo("Using new-scanning engine");
        logger.logInfo(String.format("Image Name: %s", this.getImageName()));
        logger.logInfo(String.format("Debug: %s", this.getDebug()));
        logger.logInfo(String.format("EngineURL: %s", this.getEngineurl()));
        logger.logInfo(String.format("EngineVerify: %s", this.getEngineverify()));
        logger.logInfo(String.format("Policies: %s", this.getPoliciesToApply()));
        logger.logInfo(String.format("CliVersion: %s", this.getCliVersionToApply()));
        logger.logInfo(String.format("CustomCliVersion: %s", this.getCustomCliVersion()));
        logger.logInfo(String.format("InlineScanExtraParams: %s", this.getInlineScanExtraParams()));
        logger.logInfo(String.format("BailOnFail: %s", this.getBailOnFail()));
        logger.logInfo(String.format("BailOnPluginFail: %s", this.getBailOnPluginFail()));
    }

    @Override
    public boolean getDebug() {
        return false;
    }
}

