/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult;

import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.AcceptedRisk;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.AcceptedRiskReason;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Architecture;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.EvaluationResult;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Layer;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Metadata;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.OperatingSystem;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Package;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.PackageType;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Policy;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.PolicyBundle;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.ScanType;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Severity;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Vulnerability;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class ScanResult
implements Serializable {
    private final ScanType type;
    private final Metadata metadata;
    private final Map<String, Layer> layers;
    private final Map<Package, Package> packages;
    private final Map<String, Vulnerability> vulnerabilities;
    private final Map<String, Policy> policies;
    private final Map<String, PolicyBundle> policyBundles;
    private final Map<String, AcceptedRisk> acceptedRisks;

    public ScanResult(ScanType type, String pullString, String imageID, String digest, OperatingSystem baseOS, BigInteger sizeInBytes, Architecture architecture, Map<String, String> labels, Date createdAt) {
        this.type = type;
        this.metadata = new Metadata(pullString, imageID, digest, baseOS, sizeInBytes, architecture, labels, createdAt, this);
        this.layers = new HashMap<String, Layer>();
        this.packages = new HashMap<Package, Package>();
        this.vulnerabilities = new HashMap<String, Vulnerability>();
        this.policies = new HashMap<String, Policy>();
        this.policyBundles = new HashMap<String, PolicyBundle>();
        this.acceptedRisks = new HashMap<String, AcceptedRisk>();
    }

    public Layer addLayer(String digest, BigInteger size, String command) {
        Layer layer = new Layer(digest, size, command, this);
        this.layers.put(digest, layer);
        return layer;
    }

    public Optional<Layer> findLayerByDigest(String digest) {
        return Optional.ofNullable(this.layers.get(digest));
    }

    public Collection<Layer> layers() {
        return Collections.unmodifiableCollection(this.layers.values());
    }

    public Package addPackage(PackageType type, String name, String version, String path, Layer layer) {
        Package aPackage = new Package(type, name, version, path, layer, this);
        Package addedPackage = Optional.ofNullable(this.packages.putIfAbsent(aPackage, aPackage)).orElse(aPackage);
        layer.addPackage(addedPackage);
        return addedPackage;
    }

    public Collection<Package> packages() {
        return Collections.unmodifiableCollection(this.packages.values());
    }

    public Vulnerability addVulnerability(String cve, Severity severity, Date disclosureDate, @Nullable Date solutionDate, boolean exploitable, @Nullable String fixVersion) {
        return this.vulnerabilities.computeIfAbsent(cve, k -> new Vulnerability(cve, severity, disclosureDate, solutionDate, exploitable, fixVersion, this));
    }

    public Optional<Vulnerability> findVulnerabilityByCVE(String cve) {
        return Optional.ofNullable(this.vulnerabilities.get(cve));
    }

    public Collection<Vulnerability> vulnerabilities() {
        return Collections.unmodifiableCollection(this.vulnerabilities.values());
    }

    public Policy addPolicy(String id, String name, Date createdAt, Date updatedAt) {
        return this.policies.computeIfAbsent(id, k -> new Policy(id, name, createdAt, updatedAt, this));
    }

    public Optional<Policy> findPolicyByID(String id) {
        return Optional.ofNullable(this.policies.get(id));
    }

    public Collection<Policy> policies() {
        return Collections.unmodifiableCollection(this.policies.values());
    }

    public PolicyBundle addPolicyBundle(String id, String name, Policy policy) {
        PolicyBundle policyBundle = this.policyBundles.computeIfAbsent(id, k -> new PolicyBundle(id, name, this));
        policyBundle.addPolicy(policy);
        return policyBundle;
    }

    public Optional<PolicyBundle> findPolicyBundleByID(String id) {
        return Optional.ofNullable(this.policyBundles.get(id));
    }

    public Collection<PolicyBundle> policyBundles() {
        return Collections.unmodifiableCollection(this.policyBundles.values());
    }

    public AcceptedRisk addAcceptedRisk(String id, AcceptedRiskReason reason, String description, Date expirationDate, boolean isActive, Date createdAt, Date updatedAt) {
        AcceptedRisk acceptedRisk = new AcceptedRisk(id, reason, description, expirationDate, isActive, createdAt, updatedAt, this);
        this.acceptedRisks.put(id, acceptedRisk);
        return acceptedRisk;
    }

    public Optional<AcceptedRisk> findAcceptedRiskByID(String id) {
        return Optional.ofNullable(this.acceptedRisks.get(id));
    }

    public Collection<AcceptedRisk> acceptedRisks() {
        return Collections.unmodifiableCollection(this.acceptedRisks.values());
    }

    public ScanType type() {
        return this.type;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public EvaluationResult evaluationResult() {
        boolean allPoliciesPassed = this.policies().stream().allMatch(p -> p.evaluationResult().isPassed());
        return allPoliciesPassed ? EvaluationResult.Passed : EvaluationResult.Failed;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanResult that = (ScanResult)o;
        return this.type == that.type && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.layers, that.layers) && Objects.equals(this.packages, that.packages) && Objects.equals(this.vulnerabilities, that.vulnerabilities) && Objects.equals(this.policies, that.policies) && Objects.equals(this.policyBundles, that.policyBundles) && Objects.equals(this.acceptedRisks, that.acceptedRisks);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.metadata, this.layers, this.packages, this.vulnerabilities, this.policies, this.policyBundles, this.acceptedRisks);
    }
}

