/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.domain.vm;

import com.sysdig.jenkins.plugins.sysdig.domain.SysdigLogger;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.ImageScanner;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.ScanResultArchiver;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.EvaluationResult;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.ScanResult;
import edu.umd.cs.findbugs.annotations.NonNull;

public class ImageScanningService {
    private final ImageScanner scanner;
    private final ScanResultArchiver imageScanningArchiverService;
    protected final SysdigLogger logger;

    public ImageScanningService(@NonNull ImageScanner scanner, @NonNull ScanResultArchiver imageScanningArchiverService, @NonNull SysdigLogger logger) {
        this.scanner = scanner;
        this.imageScanningArchiverService = imageScanningArchiverService;
        this.logger = logger;
    }

    public EvaluationResult scanAndArchiveResult(String imageName) throws InterruptedException {
        if (imageName.trim().isEmpty()) {
            throw new IllegalArgumentException("the image name to scan must not be empty");
        }
        ScanResult scanResult = this.scanner.scanImage(imageName);
        EvaluationResult finalAction = scanResult.evaluationResult();
        this.logger.logInfo("Sysdig Secure Container Image Scanner Plugin step result - " + String.valueOf(finalAction));
        try {
            this.imageScanningArchiverService.archiveScanResult(scanResult);
        }
        catch (Exception e) {
            this.logger.logError("Recording failure to build reports and moving on with plugin operation", e);
        }
        return finalAction;
    }
}

