/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.application.vm;

import com.sysdig.jenkins.plugins.sysdig.application.vm.ImageScanningArchiver;
import com.sysdig.jenkins.plugins.sysdig.application.vm.ImageScanningConfig;
import com.sysdig.jenkins.plugins.sysdig.application.vm.ReportStorage;
import com.sysdig.jenkins.plugins.sysdig.application.vm.report.PolicyReportProcessor;
import com.sysdig.jenkins.plugins.sysdig.domain.SysdigLogger;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.ImageScanner;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.ImageScanningService;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.EvaluationResult;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import java.util.Optional;

public class ImageScanningApplicationService {
    private final ReportStorage reportStorage;
    private final ImageScanner scanner;
    private final SysdigLogger logger;

    public ImageScanningApplicationService(ReportStorage reportStorage, ImageScanner scanner, SysdigLogger logger) {
        this.reportStorage = reportStorage;
        this.scanner = scanner;
        this.logger = logger;
    }

    public void runScan(@NonNull ImageScanningConfig config) throws AbortException {
        config.printWith(this.logger);
        Optional<EvaluationResult> finalAction = this.getFinalAction(config);
        if (finalAction.isEmpty()) {
            this.logger.logInfo("Marking Sysdig Secure Container Image Scanner step as successful, no final result");
        } else {
            if (config.getBailOnFail() && EvaluationResult.Failed.equals(finalAction.get())) {
                this.logger.logWarn("Failing Sysdig Secure Container Image Scanner Plugin step due to final result " + String.valueOf(finalAction.get()));
                throw new AbortException("Failing Sysdig Secure Container Image Scanner Plugin step due to final result " + String.valueOf(finalAction.get()));
            }
            this.logger.logInfo("Marking Sysdig Secure Container Image Scanner step as successful, final result " + String.valueOf(finalAction.get()));
        }
    }

    private Optional<EvaluationResult> getFinalAction(@NonNull ImageScanningConfig config) throws AbortException {
        PolicyReportProcessor reportProcessor = new PolicyReportProcessor(this.logger);
        ImageScanningArchiver imageScanningArchiver = new ImageScanningArchiver(reportProcessor, this.reportStorage);
        ImageScanningService imageScanningService = new ImageScanningService(this.scanner, imageScanningArchiver, this.logger);
        Optional<EvaluationResult> finalAction = Optional.empty();
        try {
            finalAction = Optional.ofNullable(imageScanningService.scanAndArchiveResult(config.getImageName()));
        }
        catch (Exception e) {
            if (config.getBailOnPluginFail()) {
                this.logger.logError("Failing Sysdig Secure Container Image Scanner Plugin step due to errors in plugin execution", e);
                throw new AbortException("Failing Sysdig Secure Container Image Scanner Plugin step due to errors in plugin execution");
            }
            this.logger.logWarn("Marking Sysdig Secure Container Image Scanner step as successful despite errors in plugin execution");
        }
        this.logger.logInfo("Completed Sysdig Secure Container Image Scanner step");
        return finalAction;
    }
}

