/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.swarmcloud.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Util;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

public final class InputValidator {
    private static final Pattern CLOUD_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]{1,64}$");
    private static final Pattern TEMPLATE_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]{1,64}$");
    private static final Pattern DOCKER_IMAGE_PATTERN = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9._:/-]*(?::[a-zA-Z0-9._-]+)?(?:@sha256:[a-f0-9]+)?$");
    private static final Pattern SERVICE_ID_PATTERN = Pattern.compile("^[a-zA-Z0-9]{25}$");
    private static final Pattern LABEL_PATTERN = Pattern.compile("^[a-zA-Z0-9_ -]{0,200}$");
    private static final Pattern NETWORK_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_.-]{1,64}$");
    private static final Pattern DOCKER_HOST_PATTERN = Pattern.compile("^(tcp|unix|npipe|ssh)://[a-zA-Z0-9._:/@-]+$");

    private InputValidator() {
    }

    public static boolean isValidCloudName(@Nullable String name) {
        if (name == null || name.isBlank()) {
            return false;
        }
        return CLOUD_NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isValidTemplateName(@Nullable String name) {
        if (name == null || name.isBlank()) {
            return false;
        }
        return TEMPLATE_NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isValidDockerImage(@Nullable String image) {
        if (image == null || image.isBlank()) {
            return false;
        }
        return DOCKER_IMAGE_PATTERN.matcher(image).matches();
    }

    public static boolean isValidServiceId(@Nullable String serviceId) {
        if (serviceId == null || serviceId.isBlank()) {
            return false;
        }
        return SERVICE_ID_PATTERN.matcher(serviceId).matches();
    }

    public static boolean isValidLabelString(@Nullable String labels) {
        if (labels == null || labels.isBlank()) {
            return true;
        }
        return LABEL_PATTERN.matcher(labels).matches();
    }

    public static boolean isValidNetworkName(@Nullable String network) {
        if (network == null || network.isBlank()) {
            return true;
        }
        return NETWORK_NAME_PATTERN.matcher(network).matches();
    }

    public static boolean isValidDockerHost(@Nullable String dockerHost) {
        if (dockerHost == null || dockerHost.isBlank()) {
            return false;
        }
        return DOCKER_HOST_PATTERN.matcher(dockerHost).matches();
    }

    @NonNull
    public static String sanitizeForLog(@Nullable String input) {
        if (input == null) {
            return "";
        }
        Object sanitized = input.replace("\n", "").replace("\r", "");
        if (((String)sanitized).length() > 200) {
            sanitized = ((String)sanitized).substring(0, 200) + "...";
        }
        return sanitized;
    }

    @NonNull
    public static String sanitizeForDisplay(@Nullable String input) {
        if (input == null) {
            return "";
        }
        return Util.escape((String)input);
    }

    public static boolean isValidMemorySpec(@Nullable String memory) {
        if (memory == null || memory.isBlank()) {
            return true;
        }
        return memory.matches("^\\d+[bkmgBKMG]?$");
    }

    public static boolean isValidCpuSpec(@Nullable String cpu) {
        if (cpu == null || cpu.isBlank()) {
            return true;
        }
        try {
            double value = Double.parseDouble(cpu);
            return value > 0.0 && value <= 100.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isValidPort(int port) {
        return port > 0 && port <= 65535;
    }

    public static boolean isValidTimeout(int timeout) {
        return timeout >= 1 && timeout <= 3600;
    }

    public static boolean isValidUrl(@Nullable String url) {
        if (url == null || url.isBlank()) {
            return false;
        }
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            return "http".equals(scheme) || "https".equals(scheme);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isValidPlacementConstraint(@Nullable String constraint) {
        if (constraint == null || constraint.isBlank()) {
            return false;
        }
        return constraint.matches("^node\\.[a-zA-Z0-9._-]+[!=]=.+$");
    }

    public static boolean isValidEnvVarName(@Nullable String name) {
        if (name == null || name.isBlank()) {
            return false;
        }
        return name.matches("^[a-zA-Z_][a-zA-Z0-9_]*$");
    }
}

