/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class StreamUtils {
    public static final int DEFAULT_PROBE_SIZE = 20;

    public static boolean isNonWhitespaceControlCharacter(@NonNull byte[] b) {
        ByteBuffer head = ByteBuffer.allocate(20);
        int toCopy = Math.min(head.remaining(), b.length);
        if (toCopy == 0) {
            throw new IllegalStateException("No more room to buffer header, should have chosen stream by now");
        }
        head.put(b, 0, toCopy);
        head.flip().mark();
        return StreamUtils.isNonWhitespaceControlCharacter(head);
    }

    public static boolean isNonWhitespaceControlCharacter(@NonNull ByteBuffer head) {
        boolean hasControlCharacter = false;
        while (head.hasRemaining()) {
            hasControlCharacter |= StreamUtils.isNonWhitespaceControlCharacter(head.get());
        }
        return hasControlCharacter;
    }

    private static boolean isNonWhitespaceControlCharacter(byte b) {
        char c = (char)(b & 0xFF);
        return Character.isISOControl(c) && c != '\t' && c != '\n' && c != '\r' && c != '\u0000';
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

