/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.timer;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.UnfilteredFileContent;
import com.cloudbees.jenkins.support.timer.FileListCap;
import com.cloudbees.jenkins.support.timer.FileListCapComponent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.security.Permission;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;

public abstract class UnfilteredFileListCapComponent
extends Component {
    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContents(@NonNull Container container, FileListCap fileListCap) {
        FileListCap fileListCap2 = fileListCap;
        synchronized (fileListCap2) {
            ArrayList files = new ArrayList(FileUtils.listFiles((File)fileListCap.getFolder(), (String[])new String[]{"txt"}, (boolean)false));
            Collections.sort(files);
            long recently = System.currentTimeMillis() - FileListCapComponent.MAX_LOG_FILE_AGE_MS;
            for (File f : files) {
                if (f.lastModified() <= recently) continue;
                container.add(new UnfilteredFileContent("{0}/{1}", new String[]{fileListCap.getFolder().getName(), f.getName()}, f, 2000000L));
            }
        }
    }
}

