/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.timer;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileListCap {
    private static final Logger LOGGER = Logger.getLogger(FileListCap.class.getName());
    private final File folder;
    private final LinkedHashSet<File> files = new LinkedHashSet();
    private int size;

    public FileListCap(File folder, int size) {
        this(folder, null, size);
    }

    public FileListCap(File folder, FilenameFilter filter, int size) {
        this.folder = folder;
        this.size = size;
        if (!folder.exists() && !folder.mkdirs()) {
            throw new Error("Failed to create " + String.valueOf(folder));
        }
        File[] sortedFiles = folder.listFiles(filter);
        if (sortedFiles == null) {
            return;
        }
        Arrays.sort(sortedFiles, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                long l = o1.lastModified() - o2.lastModified();
                if (l < 0L) {
                    return -1;
                }
                if (l > 0L) {
                    return 1;
                }
                return 0;
            }
        });
        this.files.addAll(Arrays.asList(sortedFiles));
    }

    public File getFolder() {
        return this.folder;
    }

    public int getSize() {
        return this.size;
    }

    public synchronized void add(File f) {
        if (this.size <= this.files.size()) {
            Iterator itr = this.files.iterator();
            while (this.size <= this.files.size()) {
                File old = (File)itr.next();
                if (!old.delete()) {
                    LOGGER.log(Level.WARNING, "Failed to delete {0}", old);
                }
                itr.remove();
            }
        }
        this.files.add(f);
    }

    public synchronized void touch(File f) {
        this.files.remove(f);
        this.add(f);
    }

    public File file(String path) {
        return new File(this.folder, path);
    }
}

