/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.threaddump;

import com.cloudbees.jenkins.support.impl.ThreadDumps;
import com.cloudbees.jenkins.support.timer.FileListCap;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricSet;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.PeriodicWork;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.metrics.impl.VMMetricProviderImpl;
import jenkins.model.Jenkins;

@Extension
public class HighLoadCpuChecker
extends PeriodicWork {
    public static final int RECURRENCE_PERIOD_SEC = Integer.getInteger(HighLoadCpuChecker.class.getName() + ".RECURRENCE_PERIOD_SEC", 600);
    public static final int HIGH_CPU_CONSECUTIVE_TIMES = Integer.getInteger(HighLoadCpuChecker.class.getName() + ".HIGH_CPU_CONSECUTIVE_TIMES", 3);
    public static final Double CPU_USAGE_THRESHOLD = new Double(System.getProperty(HighLoadCpuChecker.class.getName() + ".CPU_USAGE_THRESHOLD", "0.80"));
    public static final int HIGH_CPU_THREAD_DUMPS_TO_RETAIN = Integer.getInteger(HighLoadCpuChecker.class.getName() + ".HIGH_CPU_THREAD_DUMPS_TO_RETAIN", 5);
    protected final FileListCap logs = new FileListCap(new File(Jenkins.get().getRootDir(), "high-load/cpu"), HIGH_CPU_THREAD_DUMPS_TO_RETAIN);
    private final SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-HHmmss.SSS");
    private int countConsecutivePositives;
    private static final Logger LOGGER = Logger.getLogger(HighLoadCpuChecker.class.getName());

    public HighLoadCpuChecker() {
        this.format.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.countConsecutivePositives = 0;
    }

    public long getRecurrencePeriod() {
        return TimeUnit.SECONDS.toMillis(RECURRENCE_PERIOD_SEC);
    }

    protected void doRun() throws Exception {
        block8: {
            try {
                VMMetricProviderImpl vmMetricProvider = (VMMetricProviderImpl)ExtensionList.lookupSingleton(VMMetricProviderImpl.class);
                MetricSet vmProviderMetricSet = vmMetricProvider.getMetricSet();
                Gauge cpu = (Gauge)vmProviderMetricSet.getMetrics().get("vm.cpu.load");
                Double cpuLoad = new Double(cpu.getValue().toString());
                if (Double.compare((double)Runtime.getRuntime().availableProcessors() * CPU_USAGE_THRESHOLD, cpuLoad) < 0) {
                    ++this.countConsecutivePositives;
                    if (this.countConsecutivePositives < HIGH_CPU_CONSECUTIVE_TIMES) break block8;
                    this.countConsecutivePositives = 0;
                    File threadDumpFile = this.logs.file(this.format.format(new Date()) + ".txt");
                    try (FileOutputStream fileOutputStream = new FileOutputStream(threadDumpFile);){
                        ThreadDumps.threadDump(fileOutputStream);
                        this.logs.add(threadDumpFile);
                        break block8;
                    }
                }
                this.countConsecutivePositives = 0;
            }
            catch (IllegalStateException ise) {
                LOGGER.log(Level.WARNING, "Support Core plugin can't generate automatically thread dumps on high cpu load. Metrics plugin does not seem to be available", ise);
            }
        }
    }
}

