/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.startup;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.PrefilteredPrintedContent;
import com.cloudbees.jenkins.support.filter.ContentFilter;
import com.cloudbees.jenkins.support.startup.StartupReport;
import com.cloudbees.jenkins.support.timer.UnfilteredFileListCapComponent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.init.InitMilestone;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Map;

@Extension
public class StartupComponent
extends UnfilteredFileListCapComponent {
    @Override
    @NonNull
    public String getDisplayName() {
        return "Startup Report";
    }

    @Override
    public void addContents(@NonNull Container container) {
        super.addContents(container, StartupReport.get().getLogs());
        container.add(new StartupContent(StartupReport.get().getTimesPerMilestone()));
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.CONTROLLER;
    }

    private static class StartupContent
    extends PrefilteredPrintedContent {
        public static final String MILESTONE_HEADER = "Milestone";
        public static final String TIME_HEADER = "Time";
        private final Map<InitMilestone, Instant> timePerMilestone;

        StartupContent(Map<InitMilestone, Instant> timePerMilestone) {
            super("startup-timings.md");
            this.timePerMilestone = timePerMilestone;
        }

        @Override
        protected void printTo(PrintWriter out, @NonNull ContentFilter filter) {
            Instant startTime;
            Instant lastMilestoneTimestamp = startTime = Instant.ofEpochMilli(ManagementFactory.getRuntimeMXBean().getStartTime());
            InitMilestone previousMilestone = null;
            ArrayList<TimingEntry> timingEntries = new ArrayList<TimingEntry>();
            int maxMilestoneLength = MILESTONE_HEADER.length();
            int maxTimingLength = TIME_HEADER.length();
            for (InitMilestone milestone : InitMilestone.values()) {
                Instant currentMilestoneTimestamp = this.timePerMilestone.get(milestone);
                if (previousMilestone != null) {
                    String timeString;
                    String milestoneString = previousMilestone.toString();
                    if (currentMilestoneTimestamp != null) {
                        timeString = Util.getTimeSpanString((long)Duration.between(lastMilestoneTimestamp, currentMilestoneTimestamp).toMillis());
                        lastMilestoneTimestamp = currentMilestoneTimestamp;
                    } else {
                        timeString = "(No data)";
                    }
                    maxMilestoneLength = Math.max(maxMilestoneLength, milestoneString.length());
                    maxTimingLength = Math.max(maxTimingLength, timeString.length());
                    timingEntries.add(new TimingEntry(milestoneString, timeString));
                }
                previousMilestone = milestone;
            }
            Duration totalStartupTime = Duration.between(startTime, lastMilestoneTimestamp);
            out.println("| " + StartupContent.pad(MILESTONE_HEADER, maxMilestoneLength) + " | " + StartupContent.pad(TIME_HEADER, maxTimingLength) + " |");
            out.println("|" + "-".repeat(maxMilestoneLength + 2) + "|" + "-".repeat(maxTimingLength + 2) + "|");
            for (TimingEntry entry : timingEntries) {
                out.println("| " + StartupContent.pad(entry.milestone, maxMilestoneLength) + " | " + StartupContent.pad(entry.timeString, maxTimingLength) + " |");
            }
            out.println();
            out.println("Total startup time : " + Util.getTimeSpanString((long)totalStartupTime.toMillis()));
        }

        private static String pad(@NonNull Object o, int size) {
            String string = o.toString();
            return string + " ".repeat(Math.max(0, size - string.length()));
        }

        private record TimingEntry(String milestone, String timeString) {
        }
    }
}

