/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.FileContent;
import com.cloudbees.jenkins.support.impl.LogFilenameAgentFilter;
import com.cloudbees.jenkins.support.impl.LogRecordContent;
import com.cloudbees.jenkins.support.impl.SmartLogCleaner;
import com.cloudbees.jenkins.support.impl.SmartLogFetcher;
import com.cloudbees.jenkins.support.impl.WinswLogfileFilter;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.security.Permission;
import hudson.slaves.SlaveComputer;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension(ordinal=100.0)
public class SlaveLogs
extends Component {
    private static final Logger LOGGER = Logger.getLogger(SlaveLogs.class.getCanonicalName());

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Agent Log Recorders";
    }

    @Override
    public boolean isSelectedByDefault() {
        return false;
    }

    @Override
    public void addContents(@NonNull Container container) {
        ArrayList tasks = Lists.newArrayList();
        SmartLogFetcher logFetcher = new SmartLogFetcher("cache", new LogFilenameAgentFilter());
        SmartLogFetcher winswLogFetcher = new SmartLogFetcher("winsw", new WinswLogfileFilter());
        List nodes = Jenkins.get().getNodes();
        for (final Node node : nodes) {
            if (node.toComputer() instanceof SlaveComputer) {
                container.add(new LogRecordContent("nodes/slave/{0}/jenkins.log", new String[]{node.getNodeName()}){

                    @Override
                    public Iterable<LogRecord> getLogRecords() throws IOException {
                        Computer computer = node.toComputer();
                        if (computer == null) {
                            return Collections.emptyList();
                        }
                        try {
                            return Lists.reverse(new ArrayList(computer.getLogRecords()));
                        }
                        catch (InterruptedException e) {
                            throw new IOException(e);
                        }
                    }
                });
            }
            this.addAgentJulLogRecords(container, tasks, node, logFetcher);
            this.addWinsStdoutStderrLog(tasks, node, winswLogFetcher);
        }
        Set<String> activeCacheKeys = this.getActiveCacheKeys(nodes);
        new SmartLogCleaner("winsw", activeCacheKeys).execute();
        new SmartLogCleaner("cache", activeCacheKeys).execute();
        if (!tasks.isEmpty()) {
            try {
                long expiresNanoTime = System.nanoTime() + TimeUnit.SECONDS.toNanos(SupportPlugin.REMOTE_OPERATION_CACHE_TIMEOUT_SEC);
                for (Future r : Computer.threadPoolForRemoting.invokeAll(tasks, SupportPlugin.REMOTE_OPERATION_CACHE_TIMEOUT_SEC, TimeUnit.SECONDS)) {
                    try {
                        for (FileContent c : (List)r.get(Math.max(1L, expiresNanoTime - System.nanoTime()), TimeUnit.NANOSECONDS)) {
                            container.add(c);
                        }
                    }
                    catch (ExecutionException e) {
                        LOGGER.log(Level.WARNING, "Could not retrieve some of the remote node extra logs", e);
                    }
                    catch (TimeoutException e) {
                        LOGGER.log(Level.WARNING, "Could not retrieve some of the remote node extra logs", e);
                        r.cancel(false);
                    }
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Could not retrieve some of the remote node extra logs", e);
            }
        }
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.LOGS;
    }

    private void addAgentJulLogRecords(Container result, List<Callable<List<FileContent>>> tasks, final Node node, final SmartLogFetcher logFetcher) {
        final FilePath rootPath = node.getRootPath();
        if (rootPath != null) {
            tasks.add(new Callable<List<FileContent>>(){

                @Override
                public List<FileContent> call() throws Exception {
                    ArrayList<FileContent> result = new ArrayList<FileContent>();
                    FilePath supportPath = rootPath.child("support");
                    if (supportPath.isDirectory()) {
                        Map<String, File> logFiles = logFetcher.forNode(node).getLogFiles(supportPath);
                        for (Map.Entry<String, File> entry : logFiles.entrySet()) {
                            result.add(new FileContent("nodes/slave/{0}/logs/{1}", new String[]{node.getNodeName(), entry.getKey()}, entry.getValue()));
                        }
                    }
                    return result;
                }
            });
        }
        result.add(new LogRecordContent("nodes/slave/{0}/logs/all_memory_buffer.log", new String[]{node.getNodeName()}){

            @Override
            public Iterable<LogRecord> getLogRecords() throws IOException {
                try {
                    return SupportPlugin.getInstance().getAllLogRecords(node);
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException().initCause(e);
                }
            }
        });
    }

    private void addWinsStdoutStderrLog(List<Callable<List<FileContent>>> tasks, final Node node, final SmartLogFetcher logFetcher) {
        final FilePath rootPath = node.getRootPath();
        if (rootPath != null) {
            tasks.add(new Callable<List<FileContent>>(){

                @Override
                public List<FileContent> call() throws Exception {
                    ArrayList<FileContent> result = new ArrayList<FileContent>();
                    Map<String, File> logFiles = logFetcher.forNode(node).getLogFiles(rootPath);
                    for (Map.Entry<String, File> entry : logFiles.entrySet()) {
                        result.add(new FileContent("nodes/slave/{0}/logs/winsw/{1}", new String[]{node.getNodeName(), entry.getKey()}, entry.getValue(), 2000000L));
                    }
                    return result;
                }
            });
        }
    }

    private Set<String> getActiveCacheKeys(List<Node> nodes) {
        HashSet<String> cacheKeys = new HashSet<String>(nodes.size());
        for (Node node : nodes) {
            String cacheKey = Util.getDigestOf((String)(node.getNodeName() + ":" + ((Slave)node).getRemoteFS()));
            LOGGER.log(Level.FINEST, "cacheKey {0} is active", cacheKey);
            cacheKeys.add(cacheKey.substring(cacheKey.length() - 8));
        }
        return cacheKeys;
    }
}

