/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.LaunchLogsFileContent;
import com.cloudbees.jenkins.support.api.ObjectComponent;
import com.cloudbees.jenkins.support.api.ObjectComponentDescriptor;
import com.cloudbees.jenkins.support.impl.JenkinsLogs;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.console.ConsoleLogFilter;
import hudson.console.LineTransformationOutputStream;
import hudson.init.Terminator;
import hudson.model.AbstractModelObject;
import hudson.model.Computer;
import hudson.model.Run;
import hudson.security.Permission;
import hudson.slaves.SlaveComputer;
import hudson.util.io.RewindableRotatingFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.output.TeeOutputStream;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension
public class SlaveLaunchLogs
extends ObjectComponent<Computer> {
    private static final int MAX_ROTATE_LOGS = Integer.getInteger(SlaveLaunchLogs.class.getName() + ".MAX_ROTATE_LOGS", 9);
    private static final Logger LOGGER = Logger.getLogger(SlaveLaunchLogs.class.getName());

    @DataBoundConstructor
    public SlaveLaunchLogs() {
    }

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Agent Launch Logs";
    }

    @Override
    public void addContents(@NonNull Container container) {
        ((LogArchiver)((Object)ExtensionList.lookupSingleton(LogArchiver.class))).addContents(container);
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.LOGS;
    }

    @Override
    public void addContents(@NonNull Container container, Computer item) {
        File dir;
        File[] files;
        if (item.getNode() != null && item.getLogFile().lastModified() >= System.currentTimeMillis() - TimeUnit.DAYS.toMillis(7L) && (files = (dir = new File(Jenkins.get().getRootDir(), "logs/slaves/" + item.getName())).listFiles(JenkinsLogs.ROTATED_LOGFILE_FILTER)) != null) {
            for (File f : files) {
                container.add(new LaunchLogsFileContent("nodes/slave/{0}/launchLogs/{1}", new String[]{dir.getName(), f.getName()}, f, 2000000L));
            }
        }
    }

    @Override
    public boolean isSelectedByDefault() {
        return false;
    }

    @Override
    public boolean isSelectedByDefault(Computer item) {
        return true;
    }

    @Override
    public <C extends AbstractModelObject> boolean isApplicable(Class<C> clazz) {
        return Jenkins.class.isAssignableFrom(clazz) || Computer.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean isApplicable(Computer item) {
        return item != Jenkins.get().toComputer();
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    public static final class LogArchiver
    extends ConsoleLogFilter {
        private final File logDir = new File(SupportPlugin.getLogsDirectory(), "agent-launches");
        private final RewindableRotatingFileOutputStream stream = new RewindableRotatingFileOutputStream(new File(this.logDir, "all.log"), MAX_ROTATE_LOGS);

        public LogArchiver() throws IOException {
            this.stream.rewind();
        }

        public OutputStream decorateLogger(Computer computer, OutputStream logger) {
            if (computer instanceof SlaveComputer) {
                return new TeeOutputStream(logger, (OutputStream)((Object)new PrefixedStream((OutputStream)this.stream, computer.getName())));
            }
            return logger;
        }

        public OutputStream decorateLogger(Run build, OutputStream logger) throws IOException, InterruptedException {
            return logger;
        }

        public void addContents(@NonNull Container container) {
            File[] files = this.logDir.listFiles(JenkinsLogs.ROTATED_LOGFILE_FILTER);
            if (files != null) {
                for (File f : files) {
                    container.add(new LaunchLogsFileContent("nodes/slave/launches/" + f.getName(), new String[0], f, 2000000L));
                }
            }
        }

        @Terminator
        public static void close() {
            try {
                ((LogArchiver)((Object)ExtensionList.lookupSingleton(LogArchiver.class))).stream.close();
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
    }

    @Extension
    @Symbol(value={"agentsLaunchLogsComponent"})
    public static class DescriptorImpl
    extends ObjectComponentDescriptor<Computer> {
        @NonNull
        public String getDisplayName() {
            return "Agent Launch Logs";
        }
    }

    static class PrefixedStream
    extends LineTransformationOutputStream.Delegating {
        private final String name;

        PrefixedStream(OutputStream out, String name) {
            super(out);
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void eol(byte[] b, int len) throws IOException {
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                this.out.write(91);
                this.out.write(DateTimeFormatter.ISO_INSTANT.format(Instant.now().truncatedTo(ChronoUnit.MILLIS)).getBytes(StandardCharsets.US_ASCII));
                this.out.write(32);
                this.out.write(this.name.getBytes(StandardCharsets.UTF_8));
                this.out.write(93);
                this.out.write(32);
                this.out.write(b, 0, len);
            }
        }
    }
}

