/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.AsyncResultCache;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.FilePathContent;
import com.cloudbees.jenkins.support.api.ObjectComponent;
import com.cloudbees.jenkins.support.util.SystemPlatform;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.model.AbstractModelObject;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.security.Permission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public abstract class ProcFilesRetriever
extends ObjectComponent<Computer> {
    private static final Logger LOGGER = Logger.getLogger(ProcFilesRetriever.class.getName());
    private final WeakHashMap<Node, SystemPlatform> systemPlatformCache = new WeakHashMap();

    protected static String getNodeName(Node node) {
        return node instanceof Jenkins ? "master" : node.getNodeName();
    }

    public abstract Map<String, String> getFilesToRetrieve();

    protected List<Node> getNodes() {
        Jenkins jenkins = Jenkins.get();
        List agents = jenkins.getNodes();
        ArrayList<Node> allNodes = new ArrayList<Node>(agents.size() + 1);
        allNodes.add((Node)jenkins);
        allNodes.addAll(agents);
        return allNodes;
    }

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    public void addContents(@NonNull Container container) {
        for (Node node : this.getNodes()) {
            Optional.ofNullable(node.toComputer()).ifPresent(computer -> this.addContents(container, (Computer)computer));
        }
    }

    @Override
    public void addContents(@NonNull Container container, @NonNull Computer item) {
        Optional.ofNullable(item.getNode()).ifPresent(node -> this.addUnixContents(container, (Node)node));
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.PLATFORM;
    }

    protected void addUnixContents(@NonNull Container container, @NonNull Node node) {
        Computer c = node.toComputer();
        if (c == null || c.isOffline()) {
            return;
        }
        if (!Boolean.TRUE.equals(c.isUnix())) {
            return;
        }
        SystemPlatform nodeSystemPlatform = this.getSystemPlatform(node);
        if (!SystemPlatform.LINUX.equals((Object)nodeSystemPlatform)) {
            return;
        }
        Object name = node instanceof Jenkins ? "master" : "slave/" + node.getNodeName();
        for (Map.Entry<String, String> procDescriptor : this.getFilesToRetrieve().entrySet()) {
            container.add(new FilePathContent("nodes/{0}/proc/{1}", new String[]{name, procDescriptor.getValue()}, new FilePath(c.getChannel(), procDescriptor.getKey())));
        }
        this.afterAddUnixContents(container, node, (String)name);
    }

    protected void afterAddUnixContents(@NonNull Container container, @NonNull Node node, String name) {
    }

    public SystemPlatform getSystemPlatform(Node node) {
        try {
            return AsyncResultCache.get(node, this.systemPlatformCache, new SystemPlatform.GetCurrentPlatform(), "platform", SystemPlatform.UNKNOWN);
        }
        catch (IOException e) {
            LogRecord record = new LogRecord(Level.FINE, "Could not retrieve system platform type from {0}");
            record.setParameters(new Object[]{ProcFilesRetriever.getNodeName(node)});
            record.setThrown(e);
            LOGGER.log(record);
            return SystemPlatform.UNKNOWN;
        }
    }

    @Override
    public <C extends AbstractModelObject> boolean isApplicable(Class<C> clazz) {
        return Computer.class.isAssignableFrom(clazz);
    }
}

