/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.FileContent;
import com.cloudbees.jenkins.support.impl.GCLogs;
import com.cloudbees.jenkins.support.impl.JenkinsLogs;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.security.Permission;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;

@Extension(ordinal=100.0)
public class OtherLogs
extends Component {
    private static final Logger LOGGER = Logger.getLogger(OtherLogs.class.getName());

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Controller Other Log Recorders";
    }

    @Override
    public boolean isSelectedByDefault() {
        return false;
    }

    @Override
    public void addContents(@NonNull Container result) {
        this.addOtherControllerLogs(result);
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.LOGS;
    }

    private void addOtherControllerLogs(Container result) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            FileFilter fileFilter;
            String gcLogsFileLocation;
            GCLogs gcLogsComponents = (GCLogs)Jenkins.lookup(GCLogs.class);
            String string = gcLogsFileLocation = gcLogsComponents == null ? null : gcLogsComponents.getGcLogFileLocation();
            if (gcLogsFileLocation == null) {
                fileFilter = JenkinsLogs.ROTATED_LOGFILE_FILTER;
            } else {
                try {
                    if (Files.isSameFile(new File(gcLogsFileLocation).getParentFile().toPath(), jenkins.getRootDir().toPath())) {
                        Pattern gcLogFilesPattern = gcLogsComponents.isFileLocationParameterized(gcLogsFileLocation) || gcLogsComponents.isGcLogRotationConfigured() ? Pattern.compile("^" + new File(gcLogsFileLocation).getName().replaceAll("%[pt]", ".*") + ".*") : Pattern.compile("^" + new File(gcLogsFileLocation).getName() + "$");
                        fileFilter = pathname -> JenkinsLogs.ROTATED_LOGFILE_FILTER.accept(pathname) && !gcLogFilesPattern.matcher(pathname.getName()).matches();
                    } else {
                        fileFilter = JenkinsLogs.ROTATED_LOGFILE_FILTER;
                    }
                }
                catch (IOException e) {
                    LOGGER.fine("[Support Bundle] Could not check if GC Logs file location '" + gcLogsFileLocation + "' is in Jenkins root directory");
                    fileFilter = JenkinsLogs.ROTATED_LOGFILE_FILTER;
                }
            }
            File[] files = jenkins.getRootDir().listFiles(fileFilter);
            if (files != null) {
                for (File f : files) {
                    result.add(new FileContent("other-logs/{0}", new String[]{f.getName()}, f));
                }
            }
        }
    }
}

