/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.ObjectComponent;
import com.cloudbees.jenkins.support.api.ObjectComponentDescriptor;
import com.cloudbees.jenkins.support.api.PrefilteredPrintedContent;
import com.cloudbees.jenkins.support.filter.ContentFilter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractModelObject;
import hudson.model.Computer;
import hudson.model.Queue;
import hudson.model.queue.WorkUnit;
import hudson.security.Permission;
import java.io.PrintWriter;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension
public class NodeExecutors
extends ObjectComponent<Computer> {
    @DataBoundConstructor
    public NodeExecutors() {
    }

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Node Executors";
    }

    @Override
    public void addContents(@NonNull Container container) {
        container.add(new PrefilteredPrintedContent("executors.md"){

            @Override
            public void printTo(PrintWriter out, ContentFilter filter) {
                try {
                    out.println("Node Executors");
                    out.println("===========");
                    out.println();
                    Arrays.stream(Jenkins.get().getComputers()).forEach(computer -> NodeExecutors.this.dumpExecutorInfo((Computer)computer, out, filter));
                }
                finally {
                    out.flush();
                }
            }
        });
    }

    @Override
    public void addContents(@NonNull Container container, final @NonNull Computer computer) {
        container.add(new PrefilteredPrintedContent("executors.md"){

            @Override
            public void printTo(PrintWriter out, ContentFilter filter) {
                try {
                    out.println("Node Executors");
                    out.println("===========");
                    out.println();
                    NodeExecutors.this.dumpExecutorInfo(computer, out, filter);
                }
                finally {
                    out.flush();
                }
            }
        });
    }

    private void dumpExecutorInfo(@CheckForNull Computer computer, PrintWriter out, ContentFilter filter) {
        if (computer != null) {
            out.println("  * " + ContentFilter.filter(filter, computer.getDisplayName()));
            computer.getAllExecutors().forEach(executor -> {
                Queue.Executable executable;
                out.println("      - " + ContentFilter.filter(filter, executor.getDisplayName()));
                out.println("          - active: " + executor.isActive());
                out.println("          - busy: " + executor.isBusy());
                out.println("          - causesOfInterruption: [" + ContentFilter.filter(filter, executor.getCausesOfInterruption().stream().map(CauseOfInterruption::getShortDescription).collect(Collectors.joining(","))) + "]");
                out.println("          - idle: " + executor.isIdle());
                long idleStartMilliseconds = executor.getIdleStartMilliseconds();
                out.println("          - idleStartMilliseconds: " + idleStartMilliseconds + " (" + Util.XS_DATETIME_FORMATTER2.format(Instant.ofEpochMilli(idleStartMilliseconds)) + ")");
                out.println("          - progress: " + executor.getProgress());
                out.println("          - state: " + String.valueOf((Object)executor.getState()));
                WorkUnit workUnit = executor.getCurrentWorkUnit();
                if (workUnit != null) {
                    out.println("          - currentWorkUnit: " + ContentFilter.filter(filter, workUnit.toString()));
                }
                if ((executable = executor.getCurrentExecutable()) != null) {
                    out.println("          - executable: " + ContentFilter.filter(filter, executable.toString()));
                    out.println("          - elapsedTime: " + executor.getTimestampString());
                }
            });
        }
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.AGENT;
    }

    @Override
    public boolean isSelectedByDefault() {
        return false;
    }

    @Override
    public <C extends AbstractModelObject> boolean isApplicable(Class<C> clazz) {
        return Jenkins.class.isAssignableFrom(clazz) || Computer.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean isApplicable(Computer item) {
        return item != Jenkins.get().toComputer();
    }

    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    @Symbol(value={"nodeExecutors"})
    public static class DescriptorImpl
    extends ObjectComponentDescriptor<Computer> {
        @NonNull
        public String getDisplayName() {
            return "Node Executors";
        }
    }
}

