/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.AsyncResultCache;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.Content;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Node;
import hudson.security.Permission;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;

@Extension
public class NetworkInterfaces
extends Component {
    private final WeakHashMap<Node, String> networkInterfaceCache = new WeakHashMap();

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Networking Interface";
    }

    @Override
    public void addContents(@NonNull Container result) {
        result.add(new Content("nodes/master/networkInterface.md"){

            @Override
            public void writeTo(OutputStream os) throws IOException {
                os.write(NetworkInterfaces.this.getNetworkInterface((Node)Jenkins.get()).getBytes(StandardCharsets.UTF_8));
            }
        });
        for (final Node node : Jenkins.get().getNodes()) {
            result.add(new Content("nodes/slave/{0}/networkInterface.md", new String[]{node.getNodeName()}){

                @Override
                public void writeTo(OutputStream os) throws IOException {
                    os.write(NetworkInterfaces.this.getNetworkInterface(node).getBytes(StandardCharsets.UTF_8));
                }
            });
        }
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.PLATFORM;
    }

    public String getNetworkInterface(Node node) throws IOException {
        return AsyncResultCache.get(node, this.networkInterfaceCache, new GetNetworkInterfaces(), "network interfaces", "N/A: No connection to node, or no cache.");
    }

    private static final class GetNetworkInterfaces
    extends MasterToSlaveCallable<String, RuntimeException> {
        private GetNetworkInterfaces() {
        }

        public String call() {
            try {
                ArrayList<NetworkInterface> nics = new ArrayList<NetworkInterface>();
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaces.hasMoreElements()) {
                    nics.add(networkInterfaces.nextElement());
                }
                return nics.parallelStream().map(n -> GetNetworkInterfaces.nicDetails(n)).collect(Collectors.joining("\n"));
            }
            catch (SocketException e) {
                return e.getMessage();
            }
        }

        public static String nicDetails(NetworkInterface ni) {
            StringBuilder sb = new StringBuilder();
            sb.append(" * Name ").append(ni.getDisplayName()).append('\n');
            try {
                if (!ni.isUp()) {
                    sb.append(" ** Is Down\n");
                } else {
                    sb.append(" ** Is Up\n");
                    byte[] hardwareAddress = ni.getHardwareAddress();
                    if (hardwareAddress != null && hardwareAddress.length != 0) {
                        sb.append(" ** Hardware Address - ").append(Util.toHexString((byte[])hardwareAddress)).append("\n");
                    }
                    sb.append(" ** Index - ").append(ni.getIndex()).append('\n');
                    Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        InetAddress inetAddress = inetAddresses.nextElement();
                        sb.append(" ** InetAddress - ").append(inetAddress).append('\n');
                    }
                    sb.append(" ** Is Loopback - ").append(ni.isLoopback()).append('\n');
                }
            }
            catch (SocketException e) {
                sb.append(e.getMessage()).append('\n');
            }
            return sb.toString();
        }
    }
}

