/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.PrintedContent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.security.Permission;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class LoggerManager
extends Component {
    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "All loggers currently enabled";
    }

    @Override
    public void addContents(@NonNull Container container) {
        container.add(new PrintedContent("loggers.md"){

            @Override
            protected void printTo(PrintWriter out) throws IOException {
                out.println("Loggers currently enabled");
                out.println("=========================");
                LogManager logManager = LogManager.getLogManager();
                Enumeration<String> loggerNames = logManager.getLoggerNames();
                while (loggerNames.hasMoreElements()) {
                    Level level;
                    String loggerName = loggerNames.nextElement();
                    Logger loggerByName = logManager.getLogger(loggerName);
                    if (loggerByName == null || (level = loggerByName.getLevel()) == null) continue;
                    out.println(loggerName + " - " + String.valueOf(level));
                }
            }
        });
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.LOGS;
    }
}

