/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.SupportPlugin;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.FileContent;
import com.cloudbees.jenkins.support.impl.LogFilenameFilter;
import com.cloudbees.jenkins.support.impl.LogRecordContent;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.security.Permission;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;

@Extension(ordinal=100.0)
public class JenkinsLogs
extends Component {
    private static final Logger LOGGER = Logger.getLogger(JenkinsLogs.class.getName());
    protected static final FileFilter ROTATED_LOGFILE_FILTER = new FileFilter(){
        final Pattern pattern = Pattern.compile("^.*\\.log(\\.\\d+)?$");

        @Override
        public boolean accept(File f) {
            return this.pattern.matcher(f.getName()).matches() && f.length() > 0L;
        }
    };

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Controller Log Recorders";
    }

    @Override
    public void addContents(@NonNull Container result) {
        this.addControllerJulRingBuffer(result);
        this.addControllerJulLogRecords(result);
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.LOGS;
    }

    private void addControllerJulRingBuffer(Container result) {
        result.add(new LogRecordContent("nodes/master/logs/jenkins.log"){

            @Override
            public Iterable<LogRecord> getLogRecords() {
                return Lists.reverse(new ArrayList(Jenkins.logRecords));
            }
        });
    }

    private void addControllerJulLogRecords(Container result) {
        result.add(new LogRecordContent("nodes/master/logs/all_memory_buffer.log"){

            @Override
            public Iterable<LogRecord> getLogRecords() {
                return SupportPlugin.getInstance().getAllLogRecords();
            }
        });
        File[] julLogFiles = SupportPlugin.getLogsDirectory().listFiles(new LogFilenameFilter());
        if (julLogFiles == null) {
            LOGGER.log(Level.WARNING, "Cannot add controller java.util.logging logs to the bundle. Cannot access log files");
            return;
        }
        for (File file : julLogFiles) {
            result.add(new FileContent("nodes/master/logs/{0}", new String[]{file.getName()}, file));
        }
    }
}

