/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.ObjectComponentDescriptor;
import com.cloudbees.jenkins.support.impl.AdvancedProcFilesRetriever;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractModelObject;
import hudson.model.Computer;
import hudson.model.Node;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public abstract class JVMProcessSystemMetricsContents
extends AdvancedProcFilesRetriever {
    static final Set<AdvancedProcFilesRetriever.ProcFile> UNIX_PROC_CONTENTS;

    @Override
    public Set<AdvancedProcFilesRetriever.ProcFile> getProcFilesToRetrieve() {
        return UNIX_PROC_CONTENTS;
    }

    static {
        HashSet<AdvancedProcFilesRetriever.ProcFile> contents = new HashSet<AdvancedProcFilesRetriever.ProcFile>();
        contents.add(AdvancedProcFilesRetriever.ProcFile.of("/proc/meminfo", "meminfo.txt", false));
        contents.add(AdvancedProcFilesRetriever.ProcFile.of("/proc/self/status", "self/status.txt", false));
        contents.add(AdvancedProcFilesRetriever.ProcFile.of("/proc/self/cmdline", "self/cmdline", false));
        contents.add(AdvancedProcFilesRetriever.ProcFile.of("/proc/self/environ", "self/environ", true));
        contents.add(AdvancedProcFilesRetriever.ProcFile.of("/proc/self/limits", "self/limits.txt", false));
        contents.add(AdvancedProcFilesRetriever.ProcFile.of("/proc/self/mountstats", "self/mountstats.txt", false));
        UNIX_PROC_CONTENTS = Collections.unmodifiableSet(contents);
    }

    @Extension
    public static class Agents
    extends JVMProcessSystemMetricsContents {
        @DataBoundConstructor
        public Agents() {
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Agent JVM process system metrics (Linux only)";
        }

        @Override
        @NonNull
        public Component.ComponentCategory getCategory() {
            return Component.ComponentCategory.AGENT;
        }

        @Override
        public boolean isSelectedByDefault() {
            return false;
        }

        @Override
        protected List<Node> getNodes() {
            return Jenkins.get().getNodes();
        }

        @Override
        public <C extends AbstractModelObject> boolean isApplicable(Class<C> clazz) {
            return Jenkins.class.isAssignableFrom(clazz) || Computer.class.isAssignableFrom(clazz);
        }

        @Override
        public boolean isApplicable(Computer item) {
            return item != Jenkins.get().toComputer();
        }

        @Override
        public DescriptorImpl getDescriptor() {
            return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
        }

        @Override
        @NonNull
        public String getId() {
            return "AgentsJVMProcessSystemMetricsContents";
        }

        @Extension
        @Symbol(value={"agentJVMProcessSystemMetricsComponent"})
        public static class DescriptorImpl
        extends ObjectComponentDescriptor<Computer> {
            @NonNull
            public String getDisplayName() {
                return "Agent JVM process system metrics (Linux only)";
            }
        }
    }

    @Extension
    public static class Master
    extends JVMProcessSystemMetricsContents {
        @DataBoundConstructor
        public Master() {
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Controller JVM process system metrics (Linux only)";
        }

        @Override
        protected List<Node> getNodes() {
            return Collections.singletonList(Jenkins.get());
        }

        @Override
        public <C extends AbstractModelObject> boolean isApplicable(Class<C> clazz) {
            return Jenkins.class.isAssignableFrom(clazz);
        }

        @Override
        public boolean isApplicable(Computer item) {
            return item == Jenkins.get().toComputer();
        }

        @Override
        public DescriptorImpl getDescriptor() {
            return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
        }

        @Override
        @NonNull
        public String getId() {
            return "MasterJVMProcessSystemMetricsContents";
        }

        @Extension
        @Symbol(value={"masterJVMProcessSystemMetricsComponent"})
        public static class DescriptorImpl
        extends ObjectComponentDescriptor<Computer> {
            @NonNull
            public String getDisplayName() {
                return "Controller JVM process system metrics (Linux only)";
            }
        }
    }
}

