/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.PrintedContent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.security.Permission;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import jenkins.model.Jenkins;

@Extension
public class ItemsContent
extends Component {
    private final DateFormat BUILD_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.emptySet();
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Items Content (Computationally expensive)";
    }

    @Override
    public void addContents(@NonNull Container result) {
        result.add(new PrintedContent("items.md"){

            @Override
            protected void printTo(PrintWriter out) {
                Jenkins jenkins = Jenkins.getInstanceOrNull();
                if (jenkins == null) {
                    return;
                }
                TreeMap containerCounts = new TreeMap();
                HashMap jobStats = new HashMap();
                Stats jobTotal = new Stats();
                HashMap containerStats = new HashMap();
                jenkins.allItems().forEach(item -> {
                    String key;
                    Integer cnt = (Integer)containerCounts.get(key = item.getClass().getName());
                    containerCounts.put(key, cnt == null ? 1 : cnt + 1);
                    if (item instanceof Job) {
                        Job j = (Job)item;
                        int builds = 0;
                        File buildDir = jenkins.getBuildDirFor(j);
                        jobTotal.add(builds += this.countBuilds(buildDir.toPath()).intValue());
                        Stats s = (Stats)jobStats.get(key);
                        if (s == null) {
                            s = new Stats();
                            jobStats.put(key, s);
                        }
                        s.add(builds);
                    }
                    if (item instanceof ItemGroup) {
                        Stats s = (Stats)containerStats.get(key);
                        if (s == null) {
                            s = new Stats();
                            containerStats.put(key, s);
                        }
                        s.add(((ItemGroup)item).getItems().size());
                    }
                });
                out.println("Item statistics");
                out.println("===============");
                out.println();
                for (Map.Entry entry : containerCounts.entrySet()) {
                    String key = (String)entry.getKey();
                    out.println("  * `" + key + "`");
                    out.println("    - Number of items: " + String.valueOf(entry.getValue()));
                    Stats s = (Stats)jobStats.get(key);
                    if (s != null) {
                        out.println("    - Number of builds per job: " + String.valueOf(s));
                    }
                    if ((s = (Stats)containerStats.get(key)) == null) continue;
                    out.println("    - Number of items per container: " + String.valueOf(s));
                }
                out.println();
                out.println("Total job statistics");
                out.println("======================");
                out.println();
                out.println("  * Number of jobs: " + jobTotal.n());
                out.println("  * Number of builds per job: " + String.valueOf(jobTotal));
            }

            private Optional<Integer> parseInt(String fileName) {
                try {
                    return Optional.of(Integer.parseInt(fileName));
                }
                catch (NumberFormatException x) {
                    return Optional.empty();
                }
            }

            private Integer countBuilds(Path buildDirPath) {
                int builds = 0;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(buildDirPath);){
                    for (Path path : stream) {
                        if (!Files.isDirectory(path, new LinkOption[0]) || !this.parseInt(path.toFile().getName()).isPresent()) continue;
                        ++builds;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return builds;
            }

            @Override
            public boolean shouldBeFiltered() {
                return false;
            }
        });
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.CONTROLLER;
    }

    @Override
    public boolean isSelectedByDefault() {
        return true;
    }

    private static class Stats {
        private int count = 0;
        private long sumOfValues = 0L;
        private long sumOfSquaredValues = 0L;

        private Stats() {
        }

        public synchronized void add(int x) {
            ++this.count;
            this.sumOfValues += (long)x;
            this.sumOfSquaredValues += (long)x * (long)x;
        }

        public synchronized double mean() {
            return (double)this.sumOfValues / (double)this.count;
        }

        private static double roundToSigFig(double num, int sigFig) {
            if (num == 0.0) {
                return 0.0;
            }
            double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
            int pow = sigFig - (int)d;
            double mag = Math.pow(10.0, pow);
            long shifted = Math.round(num * mag);
            return (double)shifted / mag;
        }

        public synchronized double standardDeviation() {
            if (this.count >= 2) {
                double v = Math.sqrt(((double)this.count * (double)this.sumOfSquaredValues - (double)this.sumOfValues * (double)this.sumOfValues) / (double)this.count / (double)(this.count - 1));
                if (this.count <= 100) {
                    return Stats.roundToSigFig(v, 1);
                }
                if (this.count <= 1000) {
                    return Stats.roundToSigFig(v, 2);
                }
                return v;
            }
            return Double.NaN;
        }

        public synchronized String toString() {
            if (this.count == 0) {
                return "N/A";
            }
            if (this.count == 1) {
                return this.sumOfValues + " [n=" + this.count + "]";
            }
            return this.mean() + " [n=" + this.count + ", s=" + this.standardDeviation() + "]";
        }

        public synchronized int n() {
            return this.count;
        }
    }
}

