/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.AsyncResultCache;
import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.PrintedContent;
import com.cloudbees.jenkins.support.filter.PasswordRedactor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Node;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.security.Permission;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;

@Extension
public class EnvironmentVariables
extends Component {
    private static final Map<String, String> UNAVAILABLE = Collections.singletonMap("N/A", "N/A");
    private final Logger logger = Logger.getLogger(EnvironmentVariables.class.getName());
    private final WeakHashMap<Node, Map<String, String>> environmentVariableCache = new WeakHashMap();

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Environment variables";
    }

    @Override
    public void addContents(@NonNull Container result) {
        result.add(new PrintedContent("nodes/master/environment.txt"){

            @Override
            protected void printTo(PrintWriter out) throws IOException {
                try {
                    Map<String, String> environmentVariables = EnvironmentVariables.this.getEnvironmentVariables((Node)Jenkins.get());
                    for (Map.Entry<String, String> entry : PasswordRedactor.get().redact(environmentVariables).entrySet()) {
                        out.println(entry.getKey() + "=" + entry.getValue());
                    }
                }
                catch (IOException e) {
                    EnvironmentVariables.this.logger.log(Level.WARNING, "Could not record environment of controller", e);
                }
            }
        });
        for (final Node node : Jenkins.get().getNodes()) {
            result.add(new PrintedContent("nodes/slave/{0}/environment.txt", new String[]{node.getNodeName()}){

                @Override
                protected void printTo(PrintWriter out) throws IOException {
                    try {
                        Map<String, String> environmentVariables = EnvironmentVariables.this.getEnvironmentVariables(node);
                        for (Map.Entry<String, String> entry : PasswordRedactor.get().redact(environmentVariables).entrySet()) {
                            out.println(entry.getKey() + "=" + entry.getValue());
                        }
                    }
                    catch (IOException e) {
                        EnvironmentVariables.this.logger.log(Level.WARNING, "Could not record environment of node " + node.getNodeName(), e);
                    }
                }
            });
        }
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.PLATFORM;
    }

    public Map<String, String> getEnvironmentVariables(Node node) throws IOException {
        return AsyncResultCache.get(node, this.environmentVariableCache, new GetEnvironmentVariables(), "environment", UNAVAILABLE);
    }

    @Deprecated
    public static Map<String, String> getEnvironmentVariables(VirtualChannel channel) throws IOException, InterruptedException {
        if (channel == null) {
            return Collections.singletonMap("N/A", "N/A");
        }
        return (Map)channel.call((Callable)new GetEnvironmentVariables());
    }

    private static final class GetEnvironmentVariables
    extends MasterToSlaveCallable<Map<String, String>, RuntimeException> {
        private static final long serialVersionUID = 1L;

        private GetEnvironmentVariables() {
        }

        public Map<String, String> call() {
            return new TreeMap<String, String>(AccessController.doPrivileged(new PrivilegedAction<Map<String, String>>(){

                @Override
                public Map<String, String> run() {
                    return System.getenv();
                }
            }));
        }
    }
}

