/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.support.impl;

import com.cloudbees.jenkins.support.api.Component;
import com.cloudbees.jenkins.support.api.Container;
import com.cloudbees.jenkins.support.api.FileContent;
import com.cloudbees.jenkins.support.impl.LogRecordContent;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.init.Terminator;
import hudson.logging.LogRecorder;
import hudson.model.PeriodicWork;
import hudson.security.Permission;
import hudson.triggers.SafeTimerTask;
import hudson.util.CopyOnWriteList;
import hudson.util.io.RewindableFileOutputStream;
import hudson.util.io.RewindableRotatingFileOutputStream;
import io.jenkins.lib.support_log_formatter.SupportLogFormatter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension(ordinal=100.0)
public class CustomLogs
extends Component {
    private static final Logger LOGGER = Logger.getLogger(CustomLogs.class.getName());
    private static final int MAX_ROTATE_LOGS = Integer.getInteger(CustomLogs.class.getName() + ".MAX_ROTATE_LOGS", 9);
    private final File customLogs = new File(SafeTimerTask.getLogsRoot(), "custom");
    private final List<LogRecorder> logRecorders = Jenkins.get().getLog().getRecorders();

    @Override
    @NonNull
    public Set<Permission> getRequiredPermissions() {
        return Collections.singleton(Jenkins.ADMINISTER);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Controller Custom Log Recorders";
    }

    @Override
    public void addContents(@NonNull Container result) {
        this.addLogRecorders(result);
    }

    @Override
    @NonNull
    public Component.ComponentCategory getCategory() {
        return Component.ComponentCategory.LOGS;
    }

    @Override
    public boolean isSelectedByDefault() {
        return false;
    }

    private void addLogRecorders(Container result) {
        for (final LogRecorder recorder : this.logRecorders) {
            String name = recorder.getName();
            String entryName = "nodes/master/logs/custom/{0}.log";
            File storedFile = new File(this.customLogs, name + ".log");
            if (storedFile.isFile()) {
                result.add(new FileContent(entryName, new String[]{name}, storedFile));
            } else {
                result.add(new LogRecordContent(entryName, new String[]{name}){

                    @Override
                    public Iterable<LogRecord> getLogRecords() {
                        return recorder.getLogRecords();
                    }
                });
            }
            File[] rotatedLogFiles = this.customLogs.listFiles((dir, filename) -> filename.matches(name + "[.]log[.][0-9]+"));
            if (rotatedLogFiles == null) {
                LOGGER.fine("No rotated logs found for : " + name);
                return;
            }
            for (File rotatedLogFile : rotatedLogFiles) {
                String rotatedEntryName = "nodes/master/logs/custom/{0}.log.";
                try {
                    String[] logNameParts = rotatedLogFile.getName().split("\\.");
                    String logRotationNumber = logNameParts[logNameParts.length - 1];
                    result.add(new FileContent(rotatedEntryName + logRotationNumber, new String[]{name}, rotatedLogFile));
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error while adding rotated log files for " + name, e);
                }
            }
        }
    }

    @Initializer(after=InitMilestone.SYSTEM_CONFIG_ADAPTED, before=InitMilestone.JOB_LOADED)
    @Restricted(value={NoExternalUse.class})
    public void startCustomHandler() {
        Logger.getLogger("").addHandler(new CustomHandler());
    }

    static void closeAll() {
        for (Handler h : Logger.getLogger("").getHandlers()) {
            if (!(h instanceof CustomHandler)) continue;
            CustomHandler ch = (CustomHandler)h;
            for (LogFile lf : ch.logFiles.values()) {
                lf.handler.close();
            }
        }
    }

    private final class CustomHandler
    extends Handler {
        private final Map<String, LogFile> logFiles = new HashMap<String, LogFile>();

        CustomHandler() {
            Arrays.hashCode(new Class[]{Map.Entry.class, LogRecorder.class, LogRecorder.Target.class, LogFile.class, RewindableFileOutputStream.class, RewindableRotatingFileOutputStream.class, StreamHandler.class, SupportLogFormatter.class, LogFlusher.class, CopyOnWriteList.class, PrintWriter.class, Throwable.class});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void publish(LogRecord record) {
            for (LogRecorder recorder : CustomLogs.this.logRecorders) {
                for (LogRecorder.Target target : recorder.getLoggers()) {
                    if (!Boolean.TRUE.equals(target.matches(record))) continue;
                    String name = recorder.getName();
                    try {
                        LogFile logFile;
                        Map<String, LogFile> map = this.logFiles;
                        synchronized (map) {
                            logFile = this.logFiles.get(name);
                            if (logFile == null) {
                                logFile = new LogFile(name, CustomLogs.this.customLogs);
                                this.logFiles.put(name, logFile);
                            }
                        }
                        logFile.publish(record);
                    }
                    catch (IOException x) {
                        LOGGER.warning("Error while publishing log records for '" + name);
                    }
                }
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    private static final class LogFile {
        private final RewindableRotatingFileOutputStream stream;
        private final Handler handler;
        private int count;

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="if mkdirs fails, will just get a stack trace later")
        LogFile(String name, File customLogs) throws IOException {
            customLogs.mkdirs();
            this.stream = new RewindableRotatingFileOutputStream(new File(customLogs, name + ".log"), MAX_ROTATE_LOGS);
            this.stream.rewind();
            this.handler = new StreamHandler((OutputStream)this.stream, (Formatter)new SupportLogFormatter());
            this.handler.setLevel(Level.ALL);
            this.count = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void publish(LogRecord record) throws IOException {
            boolean rewind = false;
            LogFile logFile = this;
            synchronized (logFile) {
                if (this.count++ > 9999) {
                    this.count = 0;
                    rewind = true;
                }
            }
            if (rewind) {
                this.stream.rewind();
            }
            this.handler.publish(record);
            LogFlusher.scheduleFlush(this.handler);
        }
    }

    @Extension
    public static final class LogFlusher
    extends PeriodicWork {
        private static final Set<Handler> unflushedHandlers = new HashSet<Handler>();

        static synchronized void scheduleFlush(Handler h) {
            unflushedHandlers.add(h);
        }

        public long getRecurrencePeriod() {
            return 3000L;
        }

        protected void doRun() throws Exception {
            LogFlusher.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Terminator
        public static void flush() {
            Handler[] handlerArray = LogFlusher.class;
            synchronized (LogFlusher.class) {
                Handler[] handlers = unflushedHandlers.toArray(new Handler[unflushedHandlers.size()]);
                unflushedHandlers.clear();
                // ** MonitorExit[var1] (shouldn't be in output)
                for (Handler h : handlers) {
                    h.flush();
                }
                return;
            }
        }
    }
}

